/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.PayloadUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastKeepaliveHeartbeatSender {
    private static final Log LOG = LogFactory.getLog((String)MulticastKeepaliveHeartbeatSender.class.getName());
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 5000;
    private static final int MINIMUM_HEARTBEAT_INTERVAL = 1000;
    private static final int MAXIMUM_PEERS_PER_SEND = 150;
    private static long heartBeatInterval = 5000L;
    private final InetAddress groupMulticastAddress;
    private final Integer groupMulticastPort;
    private final Integer timeToLive;
    private MulticastServerThread serverThread;
    private boolean stopped;
    private final CacheManager cacheManager;

    public MulticastKeepaliveHeartbeatSender(CacheManager cacheManager, InetAddress inetAddress, Integer n, Integer n2) {
        this.cacheManager = cacheManager;
        this.groupMulticastAddress = inetAddress;
        this.groupMulticastPort = n;
        this.timeToLive = n2;
    }

    public final void init() {
        this.serverThread = new MulticastServerThread();
        this.serverThread.start();
    }

    public final synchronized void dispose() {
        this.stopped = true;
        this.notifyAll();
        this.serverThread.interrupt();
    }

    static void setHeartBeatInterval(long l) {
        if (l < 1000L) {
            LOG.warn((Object)"Trying to set heartbeat interval too low. Using MINIMUM_HEARTBEAT_INTERVAL instead.");
            heartBeatInterval = 1000L;
        } else {
            heartBeatInterval = l;
        }
    }

    public static long getHeartBeatInterval() {
        return heartBeatInterval;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    private final class MulticastServerThread
    extends Thread {
        private MulticastSocket socket;
        private List compressedUrlListList;
        private int cachePeersHash;

        public MulticastServerThread() {
            super("Multicast Server Thread");
            this.compressedUrlListList = new ArrayList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            while (!MulticastKeepaliveHeartbeatSender.this.stopped) {
                try {
                    this.socket = new MulticastSocket(MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                    this.socket.setTimeToLive(MulticastKeepaliveHeartbeatSender.this.timeToLive);
                    this.socket.joinGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    while (!MulticastKeepaliveHeartbeatSender.this.stopped) {
                        List list = this.createCachePeersPayload();
                        Object object = list.iterator();
                        while (object.hasNext()) {
                            byte[] byArray = (byte[])object.next();
                            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress, MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                            this.socket.send(datagramPacket);
                        }
                        try {
                            object = this;
                            synchronized (object) {
                                this.wait(heartBeatInterval);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (MulticastKeepaliveHeartbeatSender.this.stopped) continue;
                            LOG.error((Object)("Error receiving heartbeat. Initial cause was " + interruptedException.getMessage()), (Throwable)interruptedException);
                        }
                    }
                }
                catch (IOException iOException) {
                    LOG.debug((Object)iOException);
                }
                catch (Throwable throwable) {
                    LOG.info((Object)("Unexpected throwable in run thread. Continuing..." + throwable.getMessage()), throwable);
                }
                finally {
                    this.closeSocket();
                }
            }
        }

        private List createCachePeersPayload() {
            List list = MulticastKeepaliveHeartbeatSender.this.cacheManager.getCachePeerListener().getBoundCachePeers();
            int n = ((Object)list).hashCode();
            if (this.cachePeersHash != n) {
                this.cachePeersHash = n;
                this.compressedUrlListList = new ArrayList();
                while (list.size() > 0) {
                    int n2 = Math.min(list.size(), 150);
                    List list2 = list.subList(0, n2);
                    list = list.subList(n2, list.size());
                    byte[] byArray = PayloadUtil.assembleUrlList(list2);
                    byte[] byArray2 = PayloadUtil.gzip(byArray);
                    if (byArray2.length > 1500) {
                        LOG.fatal((Object)("Heartbeat is not working. Configure fewer caches for replication. Size is " + byArray2.length + " but should be no greater than" + 1500));
                    }
                    this.compressedUrlListList.add(byArray2);
                }
            }
            return this.compressedUrlListList;
        }

        public final void interrupt() {
            this.closeSocket();
            super.interrupt();
        }

        private void closeSocket() {
            block6: {
                try {
                    if (this.socket == null || this.socket.isClosed()) break block6;
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException iOException) {
                        LOG.error((Object)("Error leaving multicast group. Message was " + iOException.getMessage()));
                    }
                    this.socket.close();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    LOG.debug((Object)"socket.isClosed is not supported by JDK1.3");
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException iOException) {
                        LOG.error((Object)("Error leaving multicast group. Message was " + iOException.getMessage()));
                    }
                    this.socket.close();
                }
            }
        }
    }
}

