/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.MulticastRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.PayloadUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastKeepaliveHeartbeatReceiver {
    private static final Log LOG = LogFactory.getLog((String)MulticastKeepaliveHeartbeatReceiver.class.getName());
    private final InetAddress groupMulticastAddress;
    private final Integer groupMulticastPort;
    private MulticastReceiverThread receiverThread;
    private MulticastSocket socket;
    private boolean stopped;
    private final MulticastRMICacheManagerPeerProvider peerProvider;

    public MulticastKeepaliveHeartbeatReceiver(MulticastRMICacheManagerPeerProvider multicastRMICacheManagerPeerProvider, InetAddress inetAddress, Integer n) {
        this.peerProvider = multicastRMICacheManagerPeerProvider;
        this.groupMulticastAddress = inetAddress;
        this.groupMulticastPort = n;
    }

    final void init() throws IOException {
        this.socket = new MulticastSocket(this.groupMulticastPort);
        this.socket.joinGroup(this.groupMulticastAddress);
        this.receiverThread = new MulticastReceiverThread();
        this.receiverThread.start();
    }

    public final void dispose() {
        this.stopped = true;
        this.receiverThread.interrupt();
    }

    private final class MulticastReceiverThread
    extends Thread {
        private MulticastReceiverThread() {
        }

        public final void run() {
            byte[] byArray = new byte[1500];
            block4: while (true) {
                try {
                    while (!MulticastKeepaliveHeartbeatReceiver.this.stopped) {
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                        try {
                            MulticastKeepaliveHeartbeatReceiver.this.socket.receive(datagramPacket);
                            byte[] byArray2 = datagramPacket.getData();
                            this.processPayload(byArray2);
                            continue block4;
                        }
                        catch (IOException iOException) {
                            if (MulticastKeepaliveHeartbeatReceiver.this.stopped) continue;
                            LOG.error((Object)("Error receiving heartbeat. " + iOException.getMessage() + ". Initial cause was " + iOException.getMessage()), (Throwable)iOException);
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    LOG.error((Object)("Multicast receiver thread caught throwable. Cause was " + throwable.getMessage() + ". Continuing..."));
                    break;
                }
            }
        }

        private void processPayload(byte[] byArray) {
            byte[] byArray2 = PayloadUtil.ungzip(byArray);
            String string = new String(byArray2);
            if (this.self(string)) {
                return;
            }
            string = string.trim();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("rmiUrls received " + string));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerNotification(string2);
            }
        }

        private boolean self(String string) {
            CacheManager cacheManager = MulticastKeepaliveHeartbeatReceiver.this.peerProvider.getCacheManager();
            CacheManagerPeerListener cacheManagerPeerListener = cacheManager.getCachePeerListener();
            if (cacheManagerPeerListener == null) {
                return false;
            }
            List list = cacheManagerPeerListener.getBoundCachePeers();
            if (list == null || list.size() == 0) {
                return false;
            }
            CachePeer cachePeer = (CachePeer)list.get(0);
            String string2 = null;
            try {
                string2 = cachePeer.getUrlBase();
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)"Error geting url base");
            }
            int n = string.indexOf(string2);
            return n != -1;
        }

        private void registerNotification(String string) {
            MulticastKeepaliveHeartbeatReceiver.this.peerProvider.registerPeer(string);
        }

        public final void interrupt() {
            try {
                MulticastKeepaliveHeartbeatReceiver.this.socket.leaveGroup(MulticastKeepaliveHeartbeatReceiver.this.groupMulticastAddress);
            }
            catch (IOException iOException) {
                LOG.error((Object)"Error leaving group");
            }
            MulticastKeepaliveHeartbeatReceiver.this.socket.close();
            super.interrupt();
        }
    }
}

