/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.net.UnknownHostException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICachePeer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIRMICacheManagerPeerListener
extends RMICacheManagerPeerListener
implements CacheManagerPeerListener {
    private static final Log LOG = LogFactory.getLog((String)JNDIRMICacheManagerPeerListener.class.getName());

    public JNDIRMICacheManagerPeerListener(String string, Integer n, CacheManager cacheManager, Integer n2) throws UnknownHostException {
        super(string, n, cacheManager, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws CacheException {
        RMICachePeer rMICachePeer = null;
        String string = null;
        int n = 0;
        try {
            Context context = this.getInitialContext();
            this.populateListOfRemoteCachePeers();
            Map map = this.cachePeers;
            synchronized (map) {
                Iterator iterator = this.cachePeers.values().iterator();
                while (iterator.hasNext()) {
                    rMICachePeer = (RMICachePeer)iterator.next();
                    string = rMICachePeer.getName();
                    LOG.debug((Object)("binding " + string));
                    context.rebind(string, (Object)rMICachePeer);
                    ++n;
                }
            }
            LOG.debug((Object)(n + " RMICachePeers bound in JNDI for RMI listener"));
        }
        catch (Exception exception) {
            throw new CacheException("Problem starting listener for RMICachePeer " + string + " .Error was " + exception.getMessage(), exception);
        }
    }

    private Context getInitialContext() throws NamingException {
        String string = System.getProperty("java.naming.factory.initial");
        if (string != null && string.startsWith("net.sf.ehcache")) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.provider.url", "//localhost:" + this.port);
            return new InitialContext(hashtable);
        }
        return new InitialContext();
    }

    protected void disposeRMICachePeer(RMICachePeer rMICachePeer) throws Exception {
        this.getInitialContext().unbind(rMICachePeer.getName());
        UnicastRemoteObject.unexportObject(rMICachePeer, false);
    }
}

