/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.JNDIManualRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIManualRMICacheManagerPeerProviderFactory
extends RMICacheManagerPeerProviderFactory {
    private static final Log LOG = LogFactory.getLog((String)JNDIManualRMICacheManagerPeerProviderFactory.class.getName());
    private static final String JNDI_URLS = "jndiUrls";
    private static final String STASH_CONTEXTS = "stashContexts";
    private static final String STASH_REMOTE_CACHE_PEERS = "stashRemoteCachePeers";

    protected CacheManagerPeerProvider createManuallyConfiguredCachePeerProvider(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(JNDI_URLS, properties);
        if (string == null || string.length() == 0) {
            throw new CacheException("jndiUrls must be specified when peerDiscovery is manual");
        }
        boolean bl = this.isStashContexts(properties);
        boolean bl2 = this.isStashRemoteCachePeers(properties);
        JNDIManualRMICacheManagerPeerProvider jNDIManualRMICacheManagerPeerProvider = new JNDIManualRMICacheManagerPeerProvider(bl, bl2);
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            jNDIManualRMICacheManagerPeerProvider.registerPeer(string2);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Registering peer " + string2));
        }
        return jNDIManualRMICacheManagerPeerProvider;
    }

    private boolean isStashRemoteCachePeers(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(STASH_REMOTE_CACHE_PEERS, properties);
        boolean bl = string == null || string.length() == 0 ? true : Boolean.valueOf(string);
        return bl;
    }

    private boolean isStashContexts(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(STASH_CONTEXTS, properties);
        boolean bl = string == null || string.length() == 0 ? true : Boolean.valueOf(string);
        return bl;
    }
}

