/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.JNDIRMICacheManagerPeerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIManualRMICacheManagerPeerProvider
implements CacheManagerPeerProvider {
    private static final Log LOG = LogFactory.getLog((String)JNDIRMICacheManagerPeerListener.class.getName());
    protected Map peerUrls = new HashMap();
    protected Map cachePeers = new HashMap();
    private final Object lock = new Object();
    private CacheManager cacheManager;
    private boolean isStashContexts = true;
    private boolean isStashRemoteCachePeers = true;

    public JNDIManualRMICacheManagerPeerProvider(boolean bl, boolean bl2) {
        this.isStashContexts = bl;
        this.isStashRemoteCachePeers = bl2;
    }

    public JNDIManualRMICacheManagerPeerProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void init() {
    }

    public void registerPeer(String string) {
        this.registerPeerToContext(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPeer(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.peerUrls.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listRemoteCachePeers(Ehcache ehcache) throws CacheException {
        ArrayList<CachePeer> arrayList = new ArrayList<CachePeer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.peerUrls.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String string2 = JNDIManualRMICacheManagerPeerProvider.extractCacheName(string);
                try {
                    if (!string2.equals(ehcache.getName())) continue;
                    CachePeer cachePeer = this.lookupCachePeer(string);
                    arrayList.add(cachePeer);
                }
                catch (NamingException namingException) {
                    LOG.debug((Object)(string + " " + namingException.getMessage()));
                    arrayList2.add(string);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new CacheException(string + " Unable to list remote cache peers. Error was " + exception.getMessage(), exception);
                }
            }
        }
        if (!arrayList2.isEmpty()) {
            this.unregisterStalePeers(arrayList2);
        }
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug((Object)("listRemoteCachePeers " + ehcache.getName() + " returning " + arrayList.size() + " " + this.printCachePeers(arrayList)));
            }
            catch (RemoteException remoteException) {
                LOG.warn((Object)remoteException.getMessage(), (Throwable)remoteException);
                LOG.debug((Object)("listRemoteCachePeers " + ehcache.getName() + " returning " + arrayList.size()));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws CacheException {
        Object object = this.lock;
        synchronized (object) {
            this.peerUrls.clear();
            this.peerUrls = null;
            this.cachePeers.clear();
            this.cachePeers = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("dispose " + this.toString()));
        }
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private Context registerPeerToContext(String string) {
        String string2 = System.getProperty("java.naming.factory.initial");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("registerPeerToContext: " + string + " " + JNDIManualRMICacheManagerPeerProvider.extractProviderUrl(string) + " with " + string2));
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put("java.naming.provider.url", JNDIManualRMICacheManagerPeerProvider.extractProviderUrl(string));
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(hashtable);
            this.registerPeerToContext(string, initialContext);
        }
        catch (NamingException namingException) {
            LOG.warn((Object)(string + " " + namingException.getMessage()));
            this.registerPeerToContext(string, null);
        }
        return initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPeerToContext(String string, Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStashContexts) {
                this.peerUrls.put(string, context);
            } else {
                this.peerUrls.put(string, null);
            }
        }
    }

    private static String extractCacheName(String string) {
        return string.substring(string.lastIndexOf(47) + 1);
    }

    private static String extractProviderUrl(String string) {
        return string.substring(0, string.lastIndexOf(47));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(String string) {
        if (this.isStashContexts) {
            Object object = this.lock;
            synchronized (object) {
                return (Context)this.peerUrls.get(string);
            }
        }
        return null;
    }

    private void unregisterStalePeers(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.registerPeerToContext(string, null);
            this.registerCachePeer(string, null);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("unregisterStalePeers " + string));
        }
    }

    private CachePeer lookupCachePeer(String string) throws NamingException {
        CachePeer cachePeer = this.getCachePeer(string);
        boolean bl = false;
        if (cachePeer == null) {
            cachePeer = this.lookupRemoteCachePeer(string);
            if (cachePeer == null) {
                String string2 = "cachePeer null after lookup " + string;
                LOG.debug((Object)string2);
                throw new NamingException(string2);
            }
            bl = true;
        }
        cachePeer = this.getNonStaleCachePeer(string, cachePeer, bl);
        this.registerCachePeer(string, cachePeer);
        return cachePeer;
    }

    private CachePeer getNonStaleCachePeer(String string, CachePeer cachePeer, boolean bl) throws NamingException {
        boolean bl2 = this.isStale(cachePeer);
        CachePeer cachePeer2 = null;
        if (bl2) {
            if (!bl) {
                LOG.debug((Object)("CachePeer is stale, looking it up again " + string));
                cachePeer2 = this.lookupRemoteCachePeer(string);
                if (!this.isStale(cachePeer2)) {
                    bl2 = false;
                }
            }
        } else {
            cachePeer2 = cachePeer;
        }
        if (bl2) {
            String string2 = "After lookup CachePeer is stale " + string;
            LOG.info((Object)string2);
            throw new NamingException(string2);
        }
        return cachePeer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachePeer getCachePeer(String string) {
        if (this.isStashRemoteCachePeers) {
            Object object = this.lock;
            synchronized (object) {
                return (CachePeer)this.cachePeers.get(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCachePeer(String string, CachePeer cachePeer) {
        if (this.isStashRemoteCachePeers) {
            Object object = this.lock;
            synchronized (object) {
                this.cachePeers.put(string, cachePeer);
            }
        }
    }

    private CachePeer lookupRemoteCachePeer(String string) throws NamingException {
        Context context = this.getContext(string);
        if (context == null) {
            context = this.registerPeerToContext(string);
        }
        return (CachePeer)context.lookup(JNDIManualRMICacheManagerPeerProvider.extractCacheName(string));
    }

    private boolean isStale(CachePeer cachePeer) {
        try {
            cachePeer.getName();
        }
        catch (RemoteException remoteException) {
            return true;
        }
        return false;
    }

    private StringBuffer printCachePeers(List list) throws RemoteException {
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CachePeers=[");
        while (iterator.hasNext()) {
            CachePeer cachePeer = (CachePeer)iterator.next();
            stringBuffer.append(" ").append(cachePeer.toString());
        }
        stringBuffer.append("]");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(" cacheManager=").append(this.cacheManager).append(" isStashContexts=").append(this.isStashContexts).append(" isStashRemoteCachePeers=").append(this.isStashRemoteCachePeers);
        Object object = this.lock;
        synchronized (object) {
            stringBuffer.append(" peerUrls=").append(this.peerUrls).append(" cachePeers=").append(this.cachePeers);
        }
        return stringBuffer.toString();
    }
}

