/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import net.sf.ehcache.Element;

public final class EventMessage
implements Serializable {
    public static final int PUT = 0;
    public static final int REMOVE = 1;
    public static final int REMOVE_ALL = 3;
    private static final long serialVersionUID = -293616939110963629L;
    private final int event;
    private transient SoftReference elementSoftReference;
    private final Serializable key;
    private final boolean wasElementNotNull;

    public EventMessage(int n, Serializable serializable, Element element) {
        this.event = n;
        this.key = serializable;
        this.wasElementNotNull = element != null;
        this.elementSoftReference = new SoftReference<Element>(element);
    }

    public final int getEvent() {
        return this.event;
    }

    public final Element getElement() {
        return (Element)this.elementSoftReference.get();
    }

    public final Serializable getSerializableKey() {
        return this.key;
    }

    public boolean isValid() {
        if (!this.wasElementNotNull) {
            return true;
        }
        return this.getElement() != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Element element = this.getElement();
        objectOutputStream.writeObject(element);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Element element = (Element)objectInputStream.readObject();
        this.elementSoftReference = new SoftReference<Element>(element);
    }
}

