/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.filter.CachingFilter;

public abstract class PageFragmentCachingFilter
extends CachingFilter {
    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        PageInfo pageInfo = this.buildPageInfo(httpServletRequest, httpServletResponse, filterChain);
        this.writeResponse(httpServletResponse, pageInfo);
    }

    protected PageInfo buildPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GenericResponseWrapper genericResponseWrapper = new GenericResponseWrapper(httpServletResponse, byteArrayOutputStream);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)genericResponseWrapper);
        genericResponseWrapper.flush();
        return new PageInfo(genericResponseWrapper.getStatus(), genericResponseWrapper.getContentType(), genericResponseWrapper.getHeaders(), genericResponseWrapper.getCookies(), byteArrayOutputStream.toByteArray(), false);
    }

    protected void writeResponse(HttpServletResponse httpServletResponse, PageInfo pageInfo) throws IOException {
        byte[] byArray = pageInfo.getUngzippedBody();
        String string = httpServletResponse.getClass().getPackage().getImplementationVendor();
        if (string != null && string.equals("\"Evermind\"")) {
            httpServletResponse.getOutputStream().write(byArray);
        } else {
            httpServletResponse.getWriter().write(new String(byArray));
        }
    }
}

