/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.filter.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GzipFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog((String)GzipFilter.class.getName());

    protected void doInit() throws Exception {
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (!this.isIncluded(httpServletRequest) && this.acceptsEncoding(httpServletRequest, "gzip")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(httpServletRequest.getRequestURL() + ". Writing with gzip compression"));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            GenericResponseWrapper genericResponseWrapper = new GenericResponseWrapper(httpServletResponse, gZIPOutputStream);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)genericResponseWrapper);
            genericResponseWrapper.flush();
            gZIPOutputStream.close();
            int n = genericResponseWrapper.getStatus();
            if (n != 200) {
                return;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            boolean bl = ResponseUtil.shouldGzippedBodyBeZero(byArray, httpServletRequest);
            boolean bl2 = ResponseUtil.shouldBodyBeZero(httpServletRequest, genericResponseWrapper.getStatus());
            if (bl || bl2) {
                byArray = new byte[]{};
            }
            ResponseUtil.addGzipHeader(httpServletResponse);
            httpServletResponse.setContentLength(byArray.length);
            httpServletResponse.getOutputStream().write(byArray);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(httpServletRequest.getRequestURL() + ". Writing without gzip compression because the request does not accept gzip."));
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean isIncluded(HttpServletRequest httpServletRequest) {
        boolean bl;
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        boolean bl2 = bl = string != null;
        if (bl && LOG.isDebugEnabled()) {
            LOG.debug((Object)(httpServletRequest.getRequestURL() + " resulted in an include request. This is unusable, because" + "the response will be assembled into the overrall response. Not gzipping."));
        }
        return bl;
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest httpServletRequest) {
        return this.acceptsEncoding(httpServletRequest, "gzip");
    }
}

