/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Filter
implements javax.servlet.Filter {
    public static final String NO_FILTER = "NO_FILTER";
    private static final Log LOG = LogFactory.getLog((String)Filter.class.getName());
    protected FilterConfig filterConfig;
    protected String exceptionsToLogDifferently;
    protected String exceptionsToLogDifferentlyLevel;
    protected boolean suppressStackTraces;

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            if (this.filterNotDisabled(httpServletRequest)) {
                this.doFilter(httpServletRequest, httpServletResponse, filterChain);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            String string = servletRequest.getClass().getPackage().getImplementationVendor();
            if (string != null && string.equals("\"Evermind\"")) {
                httpServletResponse.getOutputStream().flush();
            } else {
                httpServletResponse.flushBuffer();
            }
        }
        catch (Throwable throwable) {
            this.logThrowable(throwable, httpServletRequest);
        }
    }

    protected boolean filterNotDisabled(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(NO_FILTER) == null;
    }

    private void logThrowable(Throwable throwable, HttpServletRequest httpServletRequest) throws ServletException {
        StringBuffer stringBuffer = new StringBuffer("Throwable thrown during doFilter on request with URI: ").append(httpServletRequest.getRequestURI()).append(" and Query: ").append(httpServletRequest.getQueryString());
        String string = stringBuffer.toString();
        boolean bl = this.matches(throwable);
        if (bl) {
            try {
                if (this.suppressStackTraces) {
                    Method method = Log.class.getMethod(this.exceptionsToLogDifferentlyLevel, Object.class);
                    method.invoke((Object)LOG, throwable.getMessage());
                } else {
                    Method method = Log.class.getMethod(this.exceptionsToLogDifferentlyLevel, Object.class, Throwable.class);
                    method.invoke((Object)LOG, throwable.getMessage(), throwable);
                }
            }
            catch (Exception exception) {
                LOG.fatal((Object)("Could not invoke Log method for " + this.exceptionsToLogDifferentlyLevel), (Throwable)exception);
            }
            throw new ServletException(string, throwable);
        }
        if (this.suppressStackTraces) {
            LOG.warn((Object)stringBuffer.append(throwable.getMessage()).append("\nTop StackTraceElement: ").append(throwable.getStackTrace()[0].toString()));
        } else {
            LOG.warn((Object)stringBuffer.append(throwable.getMessage()), throwable);
        }
        throw new ServletException(throwable);
    }

    private boolean matches(Throwable throwable) {
        Throwable throwable2;
        if (this.exceptionsToLogDifferently == null) {
            return false;
        }
        if (this.exceptionsToLogDifferently.indexOf(throwable.getClass().getName()) != -1) {
            return true;
        }
        if (throwable instanceof ServletException && this.exceptionsToLogDifferently.indexOf((throwable2 = ((ServletException)throwable).getRootCause()).getClass().getName()) != -1) {
            return true;
        }
        return throwable.getCause() != null && this.exceptionsToLogDifferently.indexOf((throwable2 = throwable.getCause()).getClass().getName()) != -1;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.filterConfig = filterConfig;
            this.processInitParams(filterConfig);
            this.doInit();
        }
        catch (Exception exception) {
            LOG.fatal((Object)"Could not initialise servlet filter.", (Throwable)exception);
            throw new ServletException("Could not initialise servlet filter.", (Throwable)exception);
        }
    }

    private void processInitParams(FilterConfig filterConfig) throws ServletException {
        String string = filterConfig.getInitParameter("exceptionsToLogDifferently");
        String string2 = filterConfig.getInitParameter("exceptionsToLogDifferentlyLevel");
        String string3 = filterConfig.getInitParameter("suppressStackTraces");
        this.suppressStackTraces = Boolean.valueOf(string3);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suppression of stack traces enabled for " + this.getClass().getName()));
        }
        if (string != null) {
            this.validateMandatoryParameters(string, string2);
            this.validateLevel(string2);
            this.exceptionsToLogDifferentlyLevel = string2;
            this.exceptionsToLogDifferently = string;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Different logging levels configured for " + this.getClass().getName()));
            }
        }
    }

    private void validateMandatoryParameters(String string, String string2) throws ServletException {
        if (string != null && string2 == null || string2 != null && string == null) {
            throw new ServletException("Invalid init-params. Both exceptionsToLogDifferently and exceptionsToLogDifferentlyLevelvalue should be specified if one is specified.");
        }
    }

    private void validateLevel(String string) throws ServletException {
        if (!(string.equals("debug") || string.equals("info") || string.equals("warn") || string.equals("error") || string.equals("fatal"))) {
            throw new ServletException("Invalid init-params value for \"exceptionsToLogDifferentlyLevel\".Must be one of debug, info, warn, error or fatal.");
        }
    }

    public final void destroy() {
        this.filterConfig = null;
        this.doDestroy();
    }

    protected boolean acceptsEncoding(HttpServletRequest httpServletRequest, String string) {
        boolean bl = this.headerContains(httpServletRequest, "Accept-Encoding", string);
        return bl;
    }

    private boolean headerContains(HttpServletRequest httpServletRequest, String string, String string2) {
        this.logRequestHeaders(httpServletRequest);
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    protected void logRequestHeaders(HttpServletRequest httpServletRequest) {
        if (LOG.isDebugEnabled()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Request Headers");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = httpServletRequest.getHeader(string);
                hashMap.put(string, string2);
                stringBuffer.append(": ").append(string).append(" -> ").append(string2);
            }
            LOG.debug((Object)stringBuffer);
        }
    }

    protected abstract void doDestroy();

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws Throwable;

    protected abstract void doInit() throws Exception;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest httpServletRequest) {
        return this.acceptsEncoding(httpServletRequest, "gzip");
    }
}

