/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.web.AlreadyCommittedException;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.SerializableCookie;
import net.sf.ehcache.constructs.web.filter.Filter;
import net.sf.ehcache.constructs.web.filter.FilterNonReentrantException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CachingFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog((String)CachingFilter.class.getName());
    protected BlockingCache blockingCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInit() throws CacheException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.blockingCache == null) {
                String string = this.getCacheName();
                Ehcache ehcache = this.getCacheManager().getEhcache(string);
                if (!(ehcache instanceof BlockingCache)) {
                    BlockingCache blockingCache = new BlockingCache(ehcache);
                    this.getCacheManager().replaceCacheWithDecoratedCache(ehcache, blockingCache);
                }
                this.blockingCache = (BlockingCache)this.getCacheManager().getEhcache(this.getCacheName());
            }
        }
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws AlreadyGzippedException, AlreadyCommittedException, FilterNonReentrantException, LockTimeoutException, Exception {
        if (httpServletResponse.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed before doing buildPage.");
        }
        this.logRequestHeaders(httpServletRequest);
        PageInfo pageInfo = this.buildPageInfo(httpServletRequest, httpServletResponse, filterChain);
        int n = pageInfo.getStatusCode();
        if (n != 200) {
            return;
        }
        if (httpServletResponse.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed after doing buildPagebut before writing response from PageInfo.");
        }
        this.writeResponse(httpServletRequest, httpServletResponse, pageInfo);
    }

    protected PageInfo buildPageInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        PageInfo pageInfo;
        block12: {
            String string = this.calculateKey(httpServletRequest);
            pageInfo = null;
            String string2 = Thread.currentThread().getName();
            try {
                this.checkNoReentry(httpServletRequest);
                Element element = this.blockingCache.get((Serializable)((Object)string));
                if (element == null || element.getObjectValue() == null) {
                    try {
                        pageInfo = this.buildPage(httpServletRequest, httpServletResponse, filterChain);
                        if (pageInfo.isOk()) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("PageInfo ok. Adding to cache " + this.blockingCache.getName() + " with key " + string));
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)string), pageInfo));
                        } else {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)("PageInfo was not ok(200). Putting null into cache " + this.blockingCache.getName() + " with key " + string));
                            }
                            this.blockingCache.put(new Element((Serializable)((Object)string), null));
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        this.blockingCache.put(new Element((Serializable)((Object)string), null));
                        throw new Exception(throwable);
                    }
                }
                pageInfo = (PageInfo)element.getObjectValue();
            }
            catch (LockTimeoutException lockTimeoutException) {
                throw lockTimeoutException;
            }
            finally {
                Thread.currentThread().setName(string2);
            }
        }
        return pageInfo;
    }

    protected PageInfo buildPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GenericResponseWrapper genericResponseWrapper = new GenericResponseWrapper(httpServletResponse, byteArrayOutputStream);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)genericResponseWrapper);
        genericResponseWrapper.flush();
        return new PageInfo(genericResponseWrapper.getStatus(), genericResponseWrapper.getContentType(), genericResponseWrapper.getHeaders(), genericResponseWrapper.getCookies(), byteArrayOutputStream.toByteArray(), true);
    }

    protected void writeResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        boolean bl = this.acceptsGzipEncoding(httpServletRequest);
        this.setStatus(httpServletResponse, pageInfo);
        this.setHeaders(pageInfo, bl, httpServletResponse);
        this.setCookies(pageInfo, httpServletResponse);
        this.setContentType(httpServletResponse, pageInfo);
        this.writeContent(httpServletRequest, httpServletResponse, pageInfo);
    }

    protected void setContentType(HttpServletResponse httpServletResponse, PageInfo pageInfo) {
        httpServletResponse.setContentType(pageInfo.getContentType());
    }

    protected void setCookies(PageInfo pageInfo, HttpServletResponse httpServletResponse) {
        List list = pageInfo.getSerializableCookies();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = ((SerializableCookie)iterator.next()).toCookie();
            httpServletResponse.addCookie(cookie);
        }
    }

    protected void setStatus(HttpServletResponse httpServletResponse, PageInfo pageInfo) {
        httpServletResponse.setStatus(pageInfo.getStatusCode());
    }

    protected void setHeaders(PageInfo pageInfo, boolean bl, HttpServletResponse httpServletResponse) {
        List list = pageInfo.getHeaders();
        boolean bl2 = false;
        boolean bl3 = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            httpServletResponse.addHeader(stringArray[0], stringArray[1]);
        }
    }

    protected abstract String getCacheName();

    protected abstract CacheManager getCacheManager();

    protected abstract String calculateKey(HttpServletRequest var1);

    protected void writeContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PageInfo pageInfo) throws IOException, ResponseHeadersNotModifiableException {
        boolean bl;
        byte[] byArray;
        if (this.acceptsGzipEncoding(httpServletRequest)) {
            ResponseUtil.addGzipHeader(httpServletResponse);
            byArray = pageInfo.getGzippedBody();
            if (ResponseUtil.shouldGzippedBodyBeZero(byArray, httpServletRequest)) {
                byArray = new byte[]{};
            }
        } else {
            byArray = pageInfo.getUngzippedBody();
        }
        if (bl = ResponseUtil.shouldBodyBeZero(httpServletRequest, pageInfo.getStatusCode())) {
            byArray = new byte[]{};
        }
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.getOutputStream().write(byArray);
    }

    protected void checkNoReentry(HttpServletRequest httpServletRequest) throws FilterNonReentrantException {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        String string2 = this.getClass().getName();
        if (thread.getName().indexOf(" been through " + string2) != -1) {
            throw new FilterNonReentrantException("The request thread is attempting to reenter filter " + string2 + ". URL: " + httpServletRequest.getRequestURL());
        }
        thread.setName(thread.getName() + " been through " + string2);
        String string3 = thread.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Thread name changed from " + string + " to " + string3));
        }
    }
}

