/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResponseUtil {
    private static final Log LOG = LogFactory.getLog((String)ResponseUtil.class.getName());
    private static final int EMPTY_GZIPPED_CONTENT_SIZE = 20;

    private ResponseUtil() {
    }

    public static boolean shouldGzippedBodyBeZero(byte[] byArray, HttpServletRequest httpServletRequest) {
        if (byArray.length == 20) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(httpServletRequest.getRequestURL() + " resulted in an empty response."));
            }
            return true;
        }
        return false;
    }

    public static boolean shouldBodyBeZero(HttpServletRequest httpServletRequest, int n) {
        if (n == 204) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(httpServletRequest.getRequestURL() + " resulted in a " + 204 + " response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        if (n == 304) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(httpServletRequest.getRequestURL() + " resulted in a " + 304 + " response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        return false;
    }

    public static void addGzipHeader(HttpServletResponse httpServletResponse) throws ResponseHeadersNotModifiableException {
        httpServletResponse.setHeader("Content-Encoding", "gzip");
        boolean bl = httpServletResponse.containsHeader("Content-Encoding");
        if (!bl) {
            throw new ResponseHeadersNotModifiableException("Failure when attempting to set Content-Encoding: gzip");
        }
    }
}

