/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.Cookie;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.SerializableCookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageInfo
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)PageInfo.class.getName());
    private static final int FOUR_KB = 4196;
    private static final int GZIP_MAGIC_NUMBER_BYTE_1 = 31;
    private static final int GZIP_MAGIC_NUMBER_BYTE_2 = -117;
    private final ArrayList headers = new ArrayList();
    private final ArrayList serializableCookies = new ArrayList();
    private String contentType;
    private byte[] gzippedBody;
    private byte[] ungzippedBody;
    private int statusCode;
    private boolean storeGzipped;

    public PageInfo(int n, String string, Collection collection, Collection collection2, byte[] byArray, boolean bl) throws AlreadyGzippedException {
        this.headers.addAll(collection);
        this.headers.remove("Content-Encoding");
        this.contentType = string;
        this.storeGzipped = bl;
        this.statusCode = n;
        this.extractCookies(collection2);
        try {
            if (bl) {
                this.ungzippedBody = null;
                this.gzippedBody = this.isBodyParameterGzipped() ? byArray : this.gzip(byArray);
            } else {
                if (this.isBodyParameterGzipped()) {
                    throw new IllegalArgumentException("Non gzip content has been gzipped.");
                }
                this.ungzippedBody = byArray;
            }
        }
        catch (IOException iOException) {
            LOG.error((Object)"Error ungzipping gzipped body", (Throwable)iOException);
        }
    }

    private void extractCookies(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            this.serializableCookies.add(new SerializableCookie(cookie));
        }
    }

    private byte[] gzip(byte[] byArray) throws IOException, AlreadyGzippedException {
        if (PageInfo.isGzipped(byArray)) {
            throw new AlreadyGzippedException("The byte[] is already gzipped. It should not be gzipped again.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isBodyParameterGzipped() {
        for (int i = 0; i < this.headers.size(); ++i) {
            String[] stringArray = (String[])this.headers.get(i);
            if (!stringArray[1].equals("gzip")) continue;
            return true;
        }
        return false;
    }

    public static boolean isGzipped(byte[] byArray) {
        if (byArray == null || byArray.length < 2) {
            return false;
        }
        return byArray[0] == 31 && byArray[1] == -117;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getGzippedBody() {
        if (this.storeGzipped) {
            return this.gzippedBody;
        }
        return null;
    }

    public List getHeaders() {
        return this.headers;
    }

    public List getSerializableCookies() {
        return this.serializableCookies;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getUngzippedBody() throws IOException {
        if (this.storeGzipped) {
            return this.ungzip(this.gzippedBody);
        }
        return this.ungzippedBody;
    }

    private byte[] ungzip(byte[] byArray) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[4196];
        int n = 0;
        while (n != -1) {
            n = gZIPInputStream.read(byArray2, 0, 4196);
            if (n == -1) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byArray3;
    }

    public boolean hasGzippedBody() {
        return this.gzippedBody != null;
    }

    public boolean hasUngzippedBody() {
        return this.ungzippedBody != null;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }
}

