/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.sf.ehcache.constructs.web.filter.FilterServletOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericResponseWrapper
extends HttpServletResponseWrapper
implements Serializable {
    private static final long serialVersionUID = -5976708169031065498L;
    private static final Log LOG = LogFactory.getLog((Class)GenericResponseWrapper.class);
    private int statusCode = 200;
    private int contentLength;
    private String contentType;
    private final List headers = new ArrayList();
    private final List cookies = new ArrayList();
    private ServletOutputStream outstr;
    private PrintWriter writer;

    public GenericResponseWrapper(HttpServletResponse httpServletResponse, OutputStream outputStream) {
        super(httpServletResponse);
        this.outstr = new FilterServletOutputStream(outputStream);
    }

    public ServletOutputStream getOutputStream() {
        return this.outstr;
    }

    public void setStatus(int n) {
        this.statusCode = n;
        super.setStatus(n);
    }

    public void sendError(int n, String string) throws IOException {
        this.statusCode = n;
        super.sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        this.statusCode = n;
        super.sendError(n);
    }

    public void sendRedirect(String string) throws IOException {
        this.statusCode = 302;
        super.sendRedirect(string);
    }

    public void setStatus(int n, String string) {
        this.statusCode = n;
        LOG.warn((Object)"Discarding message because this method is deprecated.");
        super.setStatus(n);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
        super.setContentLength(n);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String string) {
        this.contentType = string;
        super.setContentType(string);
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)this.outstr, true);
        }
        return this.writer;
    }

    public void addHeader(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        this.headers.add(stringArray);
        super.addHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.addHeader(string, string2);
    }

    public Collection getHeaders() {
        return this.headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        super.addCookie(cookie);
    }

    public Collection getCookies() {
        return this.cookies;
    }

    public void flushBuffer() throws IOException {
        this.flush();
        super.flushBuffer();
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.headers.clear();
        this.statusCode = 200;
        this.contentType = null;
        this.contentLength = 0;
    }

    public void resetBuffer() {
        super.resetBuffer();
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.outstr.flush();
    }

    public String encodeRedirectUrl(String string) {
        return super.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return super.encodeURL(string);
    }
}

