/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.concurrent.Mutex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatingSelfPopulatingCache
extends SelfPopulatingCache {
    private static final Log LOG = LogFactory.getLog((String)UpdatingSelfPopulatingCache.class.getName());

    public UpdatingSelfPopulatingCache(Ehcache ehcache, UpdatingCacheEntryFactory updatingCacheEntryFactory) throws CacheException {
        super(ehcache, updatingCacheEntryFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object object) throws LockTimeoutException {
        String string = Thread.currentThread().getName();
        this.setThreadName("get", object);
        try {
            Object object2;
            Ehcache ehcache = this.getCache();
            Element element = ehcache.get(object);
            if (element == null) {
                element = super.get(object);
            } else {
                object2 = this.getLockForKey(object);
                try {
                    ((Mutex)object2).acquire();
                    this.update(object);
                }
                finally {
                    ((Mutex)object2).release();
                }
            }
            object2 = element;
            return object2;
        }
        catch (Throwable throwable) {
            this.setThreadName("put", object);
            this.put(new Element(object, null));
            throw new LockTimeoutException("Could not fetch object for cache entry \"" + object + "\".", throwable);
        }
        finally {
            Thread.currentThread().setName(string);
        }
    }

    private void update(Object object) {
        try {
            Ehcache ehcache = this.getCache();
            Element element = ehcache.getQuiet(object);
            if (element == null && LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": entry with key " + object + " has been removed - skipping it"));
            }
            this.refreshElement(element, ehcache);
        }
        catch (Exception exception) {
            LOG.warn((Object)(this.getName() + "Could not refresh element " + object), (Throwable)exception);
        }
    }

    public void refresh() throws CacheException {
        throw new CacheException("UpdatingSelfPopulatingCache objects should not be refreshed.");
    }
}

