/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfPopulatingCache
extends BlockingCache {
    private static final Log LOG = LogFactory.getLog((String)SelfPopulatingCache.class.getName());
    protected final CacheEntryFactory factory;

    public SelfPopulatingCache(Ehcache ehcache, CacheEntryFactory cacheEntryFactory) throws CacheException {
        super(ehcache);
        this.factory = cacheEntryFactory;
    }

    public Element get(Object object) throws LockTimeoutException {
        String string = Thread.currentThread().getName();
        this.setThreadName("get", object);
        try {
            Object object2;
            Element element = super.get(object);
            if (element == null) {
                object2 = this.factory.createEntry(object);
                this.setThreadName("put", object);
                element = new Element(object, object2);
                this.put(element);
            }
            object2 = element;
            return object2;
        }
        catch (LockTimeoutException lockTimeoutException) {
            String string2 = "Timeout after " + this.timeoutMillis + " waiting on another thread " + "to fetch object for cache entry \"" + object + "\".";
            try {
                throw new LockTimeoutException(string2, lockTimeoutException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new LockTimeoutException(string2);
            }
        }
        catch (Throwable throwable) {
            this.setThreadName("put", object);
            this.put(new Element(object, null));
            try {
                throw new CacheException("Could not fetch object for cache entry \"" + object + "\".", throwable);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new CacheException("Could not fetch object for cache entry \"" + object + "\".");
            }
        }
        finally {
            Thread.currentThread().setName(string);
        }
    }

    protected void setThreadName(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer(this.getName()).append(": ").append(string).append("(").append(object).append(")");
        Thread.currentThread().setName(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CacheException {
        String string = Thread.currentThread().getName();
        Throwable throwable = null;
        List list = this.getKeys();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getName() + ": found " + list.size() + " keys to refresh"));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Serializable serializable = (Serializable)iterator.next();
            try {
                Ehcache ehcache = this.getCache();
                Element element = ehcache.getQuiet(serializable);
                if (element == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)(this.getName() + ": entry with key " + serializable + " has been removed - skipping it"));
                    continue;
                }
                this.refreshElement(element, ehcache);
            }
            catch (Exception exception) {
                LOG.warn((Object)(this.getName() + "Could not refresh element " + serializable), (Throwable)exception);
                throwable = exception;
            }
            finally {
                Thread.currentThread().setName(string);
            }
        }
        if (throwable != null) {
            throw new CacheException(throwable.getMessage());
        }
    }

    protected void refreshElement(Element element, Ehcache ehcache) throws Exception {
        Element element2;
        Object object = element.getObjectKey();
        if (LOG.isTraceEnabled()) {
            this.setThreadName("refreshElement", object);
            LOG.trace((Object)(this.getName() + ": refreshing element with key " + object));
        }
        if (this.factory instanceof UpdatingCacheEntryFactory) {
            element2 = element;
            ((UpdatingCacheEntryFactory)this.factory).updateEntryValue(object, element2.getValue());
        } else {
            Object object2 = this.factory.createEntry(object);
            element2 = new Element(object, object2);
        }
        ehcache.putQuiet(element2);
    }
}

