/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.concurrent.ConcurrencyUtil;
import net.sf.ehcache.constructs.concurrent.Mutex;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingCache
implements Ehcache {
    public static final int LOCK_NUMBER = 2048;
    private static final Log LOG = LogFactory.getLog((String)BlockingCache.class.getName());
    protected final Mutex[] locks = new Mutex[2048];
    protected final Ehcache cache;
    protected int timeoutMillis;

    public BlockingCache(Ehcache ehcache) throws CacheException {
        for (int i = 0; i < 2048; ++i) {
            this.locks[i] = new Mutex();
        }
        this.cache = ehcache;
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public void setName(String string) {
        this.cache.setName(string);
    }

    public long getTimeToIdleSeconds() {
        return this.cache.getTimeToIdleSeconds();
    }

    public long getTimeToLiveSeconds() {
        return this.cache.getTimeToLiveSeconds();
    }

    public boolean isEternal() {
        return this.cache.isEternal();
    }

    public boolean isOverflowToDisk() {
        return this.cache.isOverflowToDisk();
    }

    public int getMaxElementsInMemory() {
        return this.cache.getMaxElementsInMemory();
    }

    public int getMaxElementsOnDisk() {
        return this.cache.getMaxElementsOnDisk();
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.cache.getMemoryStoreEvictionPolicy();
    }

    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        return this.cache.isExpired(element);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isDiskPersistent() {
        return this.cache.isDiskPersistent();
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cache.getDiskExpiryThreadIntervalSeconds();
    }

    public RegisteredEventListeners getCacheEventNotificationService() {
        return this.cache.getCacheEventNotificationService();
    }

    public boolean isElementInMemory(Serializable serializable) {
        return this.cache.isElementInMemory(serializable);
    }

    public boolean isElementInMemory(Object object) {
        return this.cache.isElementInMemory(object);
    }

    public boolean isElementOnDisk(Serializable serializable) {
        return this.cache.isElementOnDisk(serializable);
    }

    public boolean isElementOnDisk(Object object) {
        return this.cache.isElementOnDisk(object);
    }

    public String getGuid() {
        return this.cache.getGuid();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void clearStatistics() {
        this.cache.clearStatistics();
    }

    public int getStatisticsAccuracy() {
        return this.cache.getStatisticsAccuracy();
    }

    public void setStatisticsAccuracy(int n) {
        this.cache.setStatisticsAccuracy(n);
    }

    public void evictExpiredElements() {
        this.cache.evictExpiredElements();
    }

    public boolean isKeyInCache(Object object) {
        return this.cache.isKeyInCache(object);
    }

    public boolean isValueInCache(Object object) {
        return this.cache.isValueInCache(object);
    }

    public Statistics getStatistics() throws IllegalStateException {
        return this.cache.getStatistics();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache.setCacheManager(cacheManager);
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.cache.getBootstrapCacheLoader();
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        this.cache.setBootstrapCacheLoader(bootstrapCacheLoader);
    }

    public void setDiskStorePath(String string) throws CacheException {
        this.cache.setDiskStorePath(string);
    }

    public void initialise() {
        this.cache.initialise();
    }

    public void bootstrap() {
        this.cache.bootstrap();
    }

    public void dispose() throws IllegalStateException {
        this.cache.dispose();
    }

    public Element get(Object object) throws LockTimeoutException {
        Mutex mutex = this.getLockForKey(object);
        try {
            if (this.timeoutMillis == 0) {
                mutex.acquire();
            } else {
                boolean bl = mutex.attempt(this.timeoutMillis);
                if (!bl) {
                    StringBuffer stringBuffer = new StringBuffer("Lock timeout. Waited more than ").append(this.timeoutMillis).append("ms to acquire lock for key ").append(object).append(" on blocking cache ").append(this.cache.getName());
                    throw new LockTimeoutException(stringBuffer.toString());
                }
            }
            Element element = this.cache.get(object);
            if (element != null) {
                mutex.release();
                return element;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new CacheException("Interrupted. Message was: " + interruptedException.getMessage());
        }
    }

    protected Mutex getLockForKey(Object object) {
        int n = ConcurrencyUtil.selectLock(object, 2048);
        return this.locks[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element) {
        if (element == null) {
            return;
        }
        Object object = element.getObjectKey();
        Object object2 = element.getObjectValue();
        Mutex mutex = this.getLockForKey(object);
        try {
            if (object2 != null) {
                this.cache.put(element);
            } else {
                this.cache.remove(object);
            }
        }
        finally {
            mutex.release();
        }
    }

    public void put(Element element, boolean bl) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.put(element, bl);
    }

    public void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.putQuiet(element);
    }

    public Element get(Serializable serializable) throws IllegalStateException, CacheException {
        return this.get((Object)serializable);
    }

    public Element getQuiet(Serializable serializable) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(serializable);
    }

    public Element getQuiet(Object object) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(object);
    }

    public List getKeys() throws CacheException {
        return this.cache.getKeys();
    }

    public List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        return this.cache.getKeysWithExpiryCheck();
    }

    public List getKeysNoDuplicateCheck() throws IllegalStateException {
        return this.cache.getKeysNoDuplicateCheck();
    }

    public boolean remove(Serializable serializable) throws IllegalStateException {
        return this.cache.remove(serializable);
    }

    public boolean remove(Object object) throws IllegalStateException {
        return this.cache.remove(object);
    }

    public boolean remove(Serializable serializable, boolean bl) throws IllegalStateException {
        return this.cache.remove(serializable, bl);
    }

    public boolean remove(Object object, boolean bl) throws IllegalStateException {
        return this.cache.remove(object, bl);
    }

    public boolean removeQuiet(Serializable serializable) throws IllegalStateException {
        return this.cache.removeQuiet(serializable);
    }

    public boolean removeQuiet(Object object) throws IllegalStateException {
        return this.cache.removeQuiet(object);
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.cache.removeAll();
    }

    public void removeAll(boolean bl) throws IllegalStateException, CacheException {
        this.cache.removeAll(bl);
    }

    public void flush() throws IllegalStateException, CacheException {
        this.cache.flush();
    }

    public int getSize() throws IllegalStateException, CacheException {
        return this.cache.getSize();
    }

    public long calculateInMemorySize() throws IllegalStateException, CacheException {
        return this.cache.calculateInMemorySize();
    }

    public long getMemoryStoreSize() throws IllegalStateException {
        return this.cache.getMemoryStoreSize();
    }

    public int getDiskStoreSize() throws IllegalStateException {
        return this.cache.getDiskStoreSize();
    }

    public Status getStatus() {
        return this.cache.getStatus();
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public void setTimeoutMillis(int n) {
        if (n < 0) {
            throw new CacheException("The lock timeout must be a positive number of ms. Value was " + n);
        }
        this.timeoutMillis = n;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

