/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.asynchronous;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.asynchronous.AsynchronousCommandException;
import net.sf.ehcache.constructs.asynchronous.Command;
import net.sf.ehcache.constructs.asynchronous.CommandNotFoundInCacheException;
import net.sf.ehcache.constructs.asynchronous.RetryAttemptTooSoonException;
import net.sf.ehcache.constructs.asynchronous.TooManyRetriesException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AsynchronousCommandExecutor {
    public static final String MESSAGE_CACHE = "net.sf.ehcache.constructs.asynchronous.MessageCache";
    public static final String SUCCESSFUL_EXECUTION = "Successful execution";
    public static final int DEFAULT_DISPATCHER_THREAD_INTERVAL_SECONDS = 60;
    public static final int MINIMUM_SAFE_DISPATCHER_THREAD_INTERVAL = 30;
    public static final String QUEUE_KEY = "QueueKey";
    private static final long WAIT_FOR_THREAD_INITIALIZATION = 5L;
    private static final Log LOG = LogFactory.getLog((String)AsynchronousCommandExecutor.class.getName());
    private static final int MS_PER_SECOND = 1000;
    private static AsynchronousCommandExecutor singleton;
    private static CacheManager cacheManager;
    private boolean active;
    private Thread dispatcherThread;
    private long dispatcherThreadIntervalSeconds;

    private AsynchronousCommandExecutor() throws CacheException {
        cacheManager = CacheManager.getInstance();
        this.addShutdownHook();
        this.active = true;
        this.dispatcherThreadIntervalSeconds = 60L;
        this.dispatcherThread = new DispatcherThread();
        this.dispatcherThread.start();
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            LOG.warn((Object)"Interrupted while initiliazing", (Throwable)interruptedException);
        }
    }

    public static synchronized AsynchronousCommandExecutor getInstance() throws AsynchronousCommandException {
        if (singleton == null) {
            try {
                singleton = new AsynchronousCommandExecutor();
            }
            catch (CacheException cacheException) {
                throw new AsynchronousCommandException("Cannot create CacheManager. Detailed message is: " + cacheException.getMessage(), cacheException);
            }
        }
        return singleton;
    }

    synchronized LinkedList getQueue() throws AsynchronousCommandException {
        LinkedList linkedList;
        Element element;
        Ehcache ehcache = this.getMessageCache();
        try {
            element = ehcache.get((Serializable)((Object)QUEUE_KEY));
        }
        catch (CacheException cacheException) {
            throw new AsynchronousCommandException("Unable to retrieve queue.", cacheException);
        }
        if (element == null) {
            linkedList = new LinkedList();
            Element element2 = new Element((Serializable)((Object)QUEUE_KEY), linkedList);
            ehcache.put(element2);
        } else {
            linkedList = (LinkedList)element.getValue();
        }
        return linkedList;
    }

    public Ehcache getMessageCache() throws AsynchronousCommandException {
        Ehcache ehcache = cacheManager.getEhcache(MESSAGE_CACHE);
        if (ehcache == null) {
            throw new AsynchronousCommandException("ehcache.xml with a configuration entry for net.sf.ehcache.constructs.asynchronous.MessageCache was not found in the classpath.");
        }
        return ehcache;
    }

    public synchronized String queueForExecution(Command command) throws AsynchronousCommandException {
        InstrumentedCommand instrumentedCommand = new InstrumentedCommand(command);
        String string = this.storeCommandToCache(instrumentedCommand);
        this.enqueue(string);
        this.notifyAll();
        return string;
    }

    private void enqueue(String string) throws AsynchronousCommandException {
        LinkedList linkedList = this.getQueue();
        linkedList.add(string);
    }

    public synchronized int getExecuteAttemptsForCommand(String string) throws CommandNotFoundInCacheException, AsynchronousCommandException {
        InstrumentedCommand instrumentedCommand = this.retrieveInstrumentedCommandFromCache(string);
        if (instrumentedCommand == null) {
            throw new CommandNotFoundInCacheException("Command " + string + " + was not found in the messageCache");
        }
        return instrumentedCommand.getExecuteAttempts();
    }

    private synchronized void dispatcherThreadMain() {
        while (true) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("dispatcherThreadIntervalSeconds: " + this.dispatcherThreadIntervalSeconds));
                }
                this.wait(this.dispatcherThreadIntervalSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"messageCache: Dispatcher thread interrupted on Disk Store.");
                }
                return;
            }
            if (!this.active) {
                return;
            }
            this.executeCommands();
        }
    }

    private synchronized void executeCommands() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("executeCommands invoked. " + this.countCachedPublishCommands() + " messages to be sent."));
        }
        LinkedList linkedList = null;
        InstrumentedCommand instrumentedCommand = null;
        try {
            linkedList = this.getQueue();
        }
        catch (AsynchronousCommandException asynchronousCommandException) {
            LOG.fatal((Object)"Unable to access the cache to retrieve commands. ", (Throwable)asynchronousCommandException);
        }
        Object var3_4 = null;
        while ((var3_4 = linkedList.peek()) != null) {
            String string = var3_4;
            try {
                try {
                    instrumentedCommand = this.retrieveInstrumentedCommandFromCache(string);
                    instrumentedCommand.attemptExecution();
                    this.remove(linkedList, string, SUCCESSFUL_EXECUTION);
                }
                catch (RetryAttemptTooSoonException retryAttemptTooSoonException) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)retryAttemptTooSoonException.getMessage(), (Throwable)retryAttemptTooSoonException);
                    break;
                }
                catch (TooManyRetriesException tooManyRetriesException) {
                    this.remove(linkedList, string, tooManyRetriesException.getMessage());
                }
                catch (CommandNotFoundInCacheException commandNotFoundInCacheException) {
                    this.remove(linkedList, string, commandNotFoundInCacheException.getMessage());
                }
            }
            catch (Throwable throwable) {
                boolean bl = this.checkIfRetryOnThrowable(throwable, instrumentedCommand);
                if (!bl) {
                    this.remove(linkedList, string, throwable.getMessage());
                    continue;
                }
                if (!LOG.isInfoEnabled()) break;
                LOG.info((Object)("Publishing attempt number " + instrumentedCommand.getExecuteAttempts() + " failed. " + throwable.getMessage()), throwable);
                break;
            }
        }
    }

    private boolean checkIfRetryOnThrowable(Throwable throwable, InstrumentedCommand instrumentedCommand) {
        Command command = instrumentedCommand.command;
        Class[] classArray = command.getThrowablesToRetryOn();
        if (classArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (!clazz.isInstance(throwable)) continue;
            bl = true;
        }
        return bl;
    }

    private void remove(Queue queue, String string, String string2) {
        queue.remove();
        Ehcache ehcache = null;
        try {
            ehcache = this.getMessageCache();
        }
        catch (AsynchronousCommandException asynchronousCommandException) {
            LOG.fatal((Object)("Unable to get cache + " + asynchronousCommandException.getMessage()), (Throwable)asynchronousCommandException);
        }
        ehcache.remove((Serializable)((Object)string));
        if (string2.equals(SUCCESSFUL_EXECUTION)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting command with uid " + string + ". " + string2));
            }
        } else {
            LOG.error((Object)("Deleting command with uid " + string + ".  " + string2));
        }
    }

    private InstrumentedCommand retrieveInstrumentedCommandFromCache(String string) throws CommandNotFoundInCacheException {
        Element element = null;
        try {
            Ehcache ehcache = this.getMessageCache();
            element = ehcache.get((Serializable)((Object)string));
        }
        catch (Exception exception) {
            throw new CommandNotFoundInCacheException("Cache error while retrieving command", exception);
        }
        if (element == null) {
            throw new CommandNotFoundInCacheException("Command " + string + " not found in cache.");
        }
        return (InstrumentedCommand)element.getValue();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (AsynchronousCommandExecutor.this.active) {
                        LOG.info((Object)("VM shutting down with the MessageDispatcher active. There are " + AsynchronousCommandExecutor.this.countCachedPublishCommands() + " messages which will be cached to disk for delivery on VM restart."));
                        AsynchronousCommandExecutor.this.dispose();
                    }
                }
            }
        });
    }

    public synchronized int countCachedPublishCommands() {
        int n = 0;
        try {
            Ehcache ehcache = this.getMessageCache();
            n = ehcache.getSize();
        }
        catch (Exception exception) {
            LOG.info((Object)"Unable to determine the number of messages in the messageCache.", (Throwable)exception);
        }
        if (n != 0) {
            --n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        int n = this.countCachedPublishCommands();
        LOG.info((Object)("Shutting down Message Dispatcher. " + n + " messages remaining."));
        if (!this.active) {
            return;
        }
        try {
            if (this.dispatcherThread != null) {
                this.dispatcherThread.interrupt();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not shut down MessageDispatcher", (Throwable)exception);
        }
        finally {
            this.active = false;
            this.notifyAll();
        }
    }

    String storeCommandToCache(InstrumentedCommand instrumentedCommand) throws AsynchronousCommandException {
        String string = this.generateUniqueIdentifier();
        Element element = new Element((Serializable)((Object)string), instrumentedCommand);
        Ehcache ehcache = this.getMessageCache();
        ehcache.put(element);
        return string;
    }

    String generateUniqueIdentifier() {
        VMID vMID = new VMID();
        return vMID.toString();
    }

    public void setDispatcherThreadIntervalSeconds(long l) throws IllegalArgumentException {
        if (l < 30L) {
            throw new IllegalArgumentException("Must be greater than 30 seconds to avoid high cpu load");
        }
        this.setUnsafeDispatcherThreadIntervalSeconds(l);
    }

    public void setUnsafeDispatcherThreadIntervalSeconds(long l) {
        this.dispatcherThreadIntervalSeconds = l;
    }

    private class DispatcherThread
    extends Thread {
        public DispatcherThread() {
            super("Message Dispatcher Thread");
            this.setDaemon(true);
        }

        public void run() {
            AsynchronousCommandExecutor.this.dispatcherThreadMain();
        }
    }

    private static final class InstrumentedCommand
    implements Serializable {
        private Command command;
        private Stack executeAttempts;

        private InstrumentedCommand(Command command) {
            this.command = command;
            this.executeAttempts = new Stack();
        }

        private void registerExecutionAttempt() {
            Date date = new Date();
            this.executeAttempts.add(date);
        }

        private void attemptExecution() throws Throwable, TooManyRetriesException, RetryAttemptTooSoonException {
            this.checkAttemptNotTooSoon();
            this.checkNotTooManyAttempts();
            this.command.execute();
        }

        private void checkAttemptNotTooSoon() throws RetryAttemptTooSoonException {
            if (!this.executeAttempts.empty()) {
                Date date = (Date)this.executeAttempts.peek();
                long l = this.command.getDelayBetweenAttemptsInSeconds() * 1000;
                Date date2 = new Date();
                Date date3 = new Date(date.getTime() + l);
                if (date2.before(date3)) {
                    throw new RetryAttemptTooSoonException("Attempt to execute command before it is due is being ignored.");
                }
            }
        }

        private void checkNotTooManyAttempts() throws TooManyRetriesException {
            this.registerExecutionAttempt();
            if (this.getExecuteAttempts() > this.command.getNumberOfAttempts()) {
                throw new TooManyRetriesException("Retry attempt number " + this.getExecuteAttempts() + " is greater than " + " the number permitted of " + this.command.getNumberOfAttempts() + ".\n" + this);
            }
        }

        private int getExecuteAttempts() {
            if (this.executeAttempts.empty()) {
                return 0;
            }
            return this.executeAttempts.size();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("InstrumentedCommand: \n").append(super.toString()).append("Previous Execution Attempts: \n");
            if (this.getExecuteAttempts() > 0) {
                for (int i = 0; i < this.getExecuteAttempts(); ++i) {
                    Date date = (Date)this.executeAttempts.get(i);
                    stringBuffer.append(date).append(" ");
                }
            }
            stringBuffer.append("Command: \n").append(this.command);
            return stringBuffer.toString();
        }
    }
}

