/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationHelper {
    private static final Log LOG = LogFactory.getLog((String)ConfigurationHelper.class.getName());
    private Configuration configuration;
    private CacheManager cacheManager;

    public ConfigurationHelper(CacheManager cacheManager, Configuration configuration) {
        if (cacheManager == null || configuration == null) {
            throw new IllegalArgumentException("Cannot have null parameters");
        }
        this.cacheManager = cacheManager;
        this.configuration = configuration;
    }

    protected static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List list = cacheConfiguration.cacheEventListenerConfigurations;
        for (int i = 0; i < list.size(); ++i) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)list.get(i);
            CacheEventListener cacheEventListener = ConfigurationHelper.createCacheEventListener(cacheEventListenerFactoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration) {
        String string = null;
        CacheEventListener cacheEventListener = null;
        try {
            string = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            LOG.debug((Object)"CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory cacheEventListenerFactory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(string);
            Properties properties = PropertyUtil.parseProperties(cacheEventListenerFactoryConfiguration.getProperties());
            cacheEventListener = cacheEventListenerFactory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    public final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration) throws CacheException {
        String string = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        try {
            string = bootstrapCacheLoaderFactoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string != null && string.length() != 0) {
            BootstrapCacheLoaderFactory bootstrapCacheLoaderFactory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(string);
            Properties properties = PropertyUtil.parseProperties(bootstrapCacheLoaderFactoryConfiguration.getProperties());
            return bootstrapCacheLoaderFactory.createBootstrapCacheLoader(properties);
        }
        LOG.debug((Object)"No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public final CacheManagerPeerProvider createCachePeerProvider() {
        String string = null;
        FactoryConfiguration factoryConfiguration = this.configuration.getCacheManagerPeerProviderFactoryConfiguration();
        try {
            string = factoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            LOG.debug((Object)"No CachePeerProviderFactoryConfiguration specified. Not configuring a CacheManagerPeerProvider.");
            return null;
        }
        CacheManagerPeerProviderFactory cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)ClassLoaderUtil.createNewInstance(string);
        Properties properties = PropertyUtil.parseProperties(factoryConfiguration.properties);
        return cacheManagerPeerProviderFactory.createCachePeerProvider(this.cacheManager, properties);
    }

    public final CacheManagerPeerListener createCachePeerListener() {
        String string = null;
        FactoryConfiguration factoryConfiguration = this.configuration.getCacheManagerPeerListenerFactoryConfiguration();
        try {
            string = factoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            LOG.debug((Object)"No CachePeerListenerFactoryConfiguration specified. Not configuring a CacheManagerPeerListener.");
            return null;
        }
        CacheManagerPeerListenerFactory cacheManagerPeerListenerFactory = (CacheManagerPeerListenerFactory)ClassLoaderUtil.createNewInstance(string);
        Properties properties = PropertyUtil.parseProperties(factoryConfiguration.properties);
        return cacheManagerPeerListenerFactory.createCachePeerListener(this.cacheManager, properties);
    }

    public final CacheManagerEventListener createCacheManagerEventListener() throws CacheException {
        String string = null;
        FactoryConfiguration factoryConfiguration = this.configuration.getCacheManagerEventListenerFactoryConfiguration();
        try {
            string = factoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            LOG.debug((Object)"No CacheManagerEventListenerFactory class specified. Skipping...");
            return null;
        }
        CacheManagerEventListenerFactory cacheManagerEventListenerFactory = (CacheManagerEventListenerFactory)ClassLoaderUtil.createNewInstance(string);
        Properties properties = PropertyUtil.parseProperties(factoryConfiguration.properties);
        return cacheManagerEventListenerFactory.createCacheManagerEventListener(properties);
    }

    public final String getDiskStorePath() {
        DiskStoreConfiguration diskStoreConfiguration = this.configuration.getDiskStoreConfiguration();
        if (diskStoreConfiguration == null) {
            return null;
        }
        return diskStoreConfiguration.getPath();
    }

    public final Ehcache createDefaultCache() throws CacheException {
        CacheConfiguration cacheConfiguration = this.configuration.getDefaultCacheConfiguration();
        if (cacheConfiguration == null) {
            throw new CacheException("Illegal configuration. No default cache is configured.");
        }
        cacheConfiguration.name = "default";
        return this.createCache(cacheConfiguration);
    }

    public final Set createCaches() {
        HashSet<Cache> hashSet = new HashSet<Cache>();
        Set set = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            Cache cache = this.createCache(cacheConfiguration);
            hashSet.add(cache);
        }
        return hashSet;
    }

    public final Integer numberOfCachesThatOverflowToDisk() {
        int n = 0;
        Set set = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.overflowToDisk) continue;
            ++n;
        }
        return new Integer(n);
    }

    final Ehcache createCacheFromName(String string) {
        CacheConfiguration cacheConfiguration = null;
        Set set = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration2 = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration2.name.equals(string)) continue;
            cacheConfiguration = cacheConfiguration2;
            break;
        }
        if (cacheConfiguration == null) {
            return null;
        }
        return this.createCache(cacheConfiguration);
    }

    final Cache createCache(CacheConfiguration cacheConfiguration) {
        Cache cache = new Cache(cacheConfiguration.name, cacheConfiguration.maxElementsInMemory, cacheConfiguration.memoryStoreEvictionPolicy, cacheConfiguration.overflowToDisk, this.getDiskStorePath(), cacheConfiguration.eternal, cacheConfiguration.timeToLiveSeconds, cacheConfiguration.timeToIdleSeconds, cacheConfiguration.diskPersistent, cacheConfiguration.diskExpiryThreadIntervalSeconds, null, null, cacheConfiguration.maxElementsOnDisk);
        RegisteredEventListeners registeredEventListeners = cache.getCacheEventNotificationService();
        ConfigurationHelper.registerCacheListeners(cacheConfiguration, registeredEventListeners);
        BootstrapCacheLoader bootstrapCacheLoader = this.createBootstrapCacheLoader(cacheConfiguration.bootstrapCacheLoaderFactoryConfiguration);
        cache.setBootstrapCacheLoader(bootstrapCacheLoader);
        return cache;
    }

    public final Configuration getConfigurationBean() {
        return this.configuration;
    }
}

