/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.BeanHandler;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigurationFactory {
    private static final Log LOG = LogFactory.getLog((String)ConfigurationFactory.class.getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "/ehcache.xml";
    private static final String FAILSAFE_CLASSPATH_CONFIGURATION_FILE = "/ehcache-failsafe.xml";

    private ConfigurationFactory() {
    }

    public static Configuration parseConfiguration(File file) throws CacheException {
        if (file == null) {
            throw new CacheException("Attempt to configure ehcache from null file.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configuring ehcache from file: " + file.toString()));
        }
        Configuration configuration = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            configuration = ConfigurationFactory.parseConfiguration(inputStream);
        }
        catch (Exception exception) {
            throw new CacheException("Error configuring from " + file + ". Initial cause was " + exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOG.error((Object)("IOException while closing configuration input stream. Error was " + iOException.getMessage()));
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration(URL uRL) throws CacheException {
        Configuration configuration;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configuring ehcache from URL: " + uRL));
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            configuration = ConfigurationFactory.parseConfiguration(inputStream);
        }
        catch (Exception exception) {
            throw new CacheException("Error configuring from " + uRL + ". Initial cause was " + exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOG.error((Object)("IOException while closing configuration input stream. Error was " + iOException.getMessage()));
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration() throws CacheException {
        ClassLoader classLoader = ClassLoaderUtil.getStandardClassLoader();
        URL uRL = null;
        if (classLoader != null) {
            uRL = classLoader.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (uRL == null) {
            uRL = ConfigurationFactory.class.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (uRL != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configuring ehcache from ehcache.xml found in the classpath: " + uRL));
            }
        } else {
            uRL = ConfigurationFactory.class.getResource(FAILSAFE_CLASSPATH_CONFIGURATION_FILE);
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("No configuration found. Configuring ehcache from ehcache-failsafe.xml  found in the classpath: " + uRL));
            }
        }
        return ConfigurationFactory.parseConfiguration(uRL);
    }

    public static Configuration parseConfiguration(InputStream inputStream) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Configuring ehcache from InputStream");
        }
        Configuration configuration = new Configuration();
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            BeanHandler beanHandler = new BeanHandler(configuration);
            sAXParser.parse(inputStream, (DefaultHandler)beanHandler);
        }
        catch (Exception exception) {
            throw new CacheException("Error configuring from input stream. Initial cause was " + exception.getMessage(), exception);
        }
        return configuration;
    }
}

