/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheConfiguration {
    protected String name;
    protected int maxElementsInMemory;
    protected int maxElementsOnDisk;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    protected boolean eternal;
    protected int timeToIdleSeconds;
    protected int timeToLiveSeconds;
    protected boolean overflowToDisk;
    protected boolean diskPersistent;
    protected long diskExpiryThreadIntervalSeconds;
    protected final List cacheEventListenerConfigurations = new ArrayList();
    protected BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration;

    public final void setName(String string) {
        this.name = string;
    }

    public final void setMaxElementsInMemory(int n) {
        this.maxElementsInMemory = n;
    }

    public final void setMemoryStoreEvictionPolicy(String string) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(string);
    }

    public final void setEternal(boolean bl) {
        this.eternal = bl;
    }

    public final void setTimeToIdleSeconds(int n) {
        this.timeToIdleSeconds = n;
    }

    public final void setTimeToLiveSeconds(int n) {
        this.timeToLiveSeconds = n;
    }

    public final void setOverflowToDisk(boolean bl) {
        this.overflowToDisk = bl;
    }

    public final void setDiskPersistent(boolean bl) {
        this.diskPersistent = bl;
    }

    public void setMaxElementsOnDisk(int n) {
        this.maxElementsOnDisk = n;
    }

    public final void setDiskExpiryThreadIntervalSeconds(int n) {
        this.diskExpiryThreadIntervalSeconds = n;
    }

    public final void addCacheEventListenerFactory(CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration) {
        this.cacheEventListenerConfigurations.add(cacheEventListenerFactoryConfiguration);
    }

    public final void addBootstrapCacheLoaderFactory(BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration) {
        this.bootstrapCacheLoaderFactoryConfiguration = bootstrapCacheLoaderFactoryConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public int getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public List getCacheEventListenerConfigurations() {
        return this.cacheEventListenerConfigurations;
    }

    public BootstrapCacheLoaderFactoryConfiguration getBootstrapCacheLoaderFactoryConfiguration() {
        return this.bootstrapCacheLoaderFactoryConfiguration;
    }

    public final class BootstrapCacheLoaderFactoryConfiguration
    extends FactoryConfiguration {
    }

    public final class CacheEventListenerFactoryConfiguration
    extends FactoryConfiguration {
    }
}

