/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class BeanHandler
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog((String)BeanHandler.class.getName());
    private final Object bean;
    private ElementInfo element;
    private Locator locator;

    public BeanHandler(Object object) {
        this.bean = object;
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.element == null) {
            this.element = new ElementInfo(string3, this.bean);
        } else {
            Object object = this.createChild(this.element, string3);
            this.element = new ElementInfo(this.element, string3, object);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            this.setAttribute(this.element, string4, string5);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.element.parent != null) {
            this.addChild(this.element.parent.bean, this.element.bean, string3);
        }
        this.element = this.element.parent;
    }

    private Object createChild(ElementInfo elementInfo, String string) throws SAXException {
        try {
            Class<?> clazz = elementInfo.bean.getClass();
            Method method = BeanHandler.findCreateMethod(clazz, string);
            if (method != null) {
                return method.invoke(elementInfo.bean, new Object[0]);
            }
            method = this.findSetMethod(clazz, "add", string);
            if (method != null) {
                return BeanHandler.createInstance(elementInfo.bean, method.getParameterTypes()[0]);
            }
        }
        catch (Exception exception) {
            throw new SAXException(this.getLocation() + ": Could not create nested element <" + string + ">.");
        }
        throw new SAXException(this.getLocation() + ": Element <" + elementInfo.elementName + "> does not allow nested <" + string + "> elements.");
    }

    private static Object createInstance(Object object, Class clazz) throws Exception {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length == 0) {
                arrayList.add(constructor);
                continue;
            }
            if (classArray.length != 1 || !classArray[0].isInstance(object)) continue;
            arrayList.add(constructor);
        }
        switch (arrayList.size()) {
            case 0: {
                throw new Exception("No constructor for class " + clazz.getName());
            }
            case 1: {
                break;
            }
            default: {
                throw new Exception("Multiple constructors for class " + clazz.getName());
            }
        }
        Constructor constructor = (Constructor)arrayList.remove(0);
        if (constructor.getParameterTypes().length == 0) {
            return constructor.newInstance(new Object[0]);
        }
        return constructor.newInstance(object);
    }

    private static Method findCreateMethod(Class clazz, String string) {
        String string2 = BeanHandler.makeMethodName("create", string);
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string2) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().isPrimitive() || method.getReturnType().isArray()) continue;
            return method;
        }
        return null;
    }

    private static String makeMethodName(String string, String string2) {
        return string + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    private void setAttribute(ElementInfo elementInfo, String string, String string2) throws SAXException {
        try {
            Class<?> clazz = elementInfo.bean.getClass();
            Method method = this.findSetMethod(clazz, "set", string);
            if (method != null) {
                Object object = BeanHandler.convert(method.getParameterTypes()[0], string2);
                method.invoke(elementInfo.bean, object);
                return;
            }
            if (elementInfo.elementName.equals("ehcache")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignoring ehcache attribute " + string));
                }
                return;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SAXException(this.getLocation() + ": Could not set attribute \"" + string + "\"." + ". Message was: " + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new SAXException(this.getLocation() + ": Could not set attribute \"" + string + "\".");
        }
        throw new SAXException(this.getLocation() + ": Element <" + elementInfo.elementName + "> does not allow attribute \"" + string + "\".");
    }

    private static Object convert(Class clazz, String string) throws Exception {
        if (string == null) {
            return null;
        }
        if (clazz.isInstance(string)) {
            return string;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.decode(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.decode(string);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.valueOf(string);
        }
        throw new Exception("Cannot convert attribute value to class " + clazz.getName());
    }

    private Method findSetMethod(Class clazz, String string, String string2) throws Exception {
        String string3 = BeanHandler.makeMethodName(string, string2);
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string3) || Modifier.isStatic(method2.getModifiers()) || method2.getParameterTypes().length != 1 || !method2.getReturnType().equals(Void.TYPE)) continue;
            if (method != null) {
                throw new Exception("Multiple " + string3 + "() methods in class " + clazz.getName() + ".");
            }
            method = method2;
        }
        return method;
    }

    private void addChild(Object object, Object object2, String string) throws SAXException {
        try {
            Method method = this.findSetMethod(object.getClass(), "add", string);
            if (method != null) {
                method.invoke(object, object2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            SAXException sAXException = new SAXException(this.getLocation() + ": Could not finish element <" + string + ">." + " Message was: " + invocationTargetException.getTargetException());
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(this.getLocation() + ": Could not finish element <" + string + ">.");
        }
    }

    private String getLocation() {
        return this.locator.getSystemId() + ':' + this.locator.getLineNumber();
    }

    private static final class ElementInfo {
        private final ElementInfo parent;
        private final String elementName;
        private final Object bean;

        public ElementInfo(String string, Object object) {
            this.parent = null;
            this.elementName = string;
            this.bean = object;
        }

        public ElementInfo(ElementInfo elementInfo, String string, Object object) {
            this.parent = elementInfo;
            this.elementName = string;
            this.bean = object;
        }
    }
}

