/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Statistics
implements Serializable {
    public static final int STATISTICS_ACCURACY_BEST_EFFORT = 0;
    public static final int STATISTICS_ACCURACY_GUARANTEED = 1;
    public static final int STATISTICS_ACCURACY_NONE = 2;
    private static final Log LOG = LogFactory.getLog((String)Statistics.class.getName());
    private static final long serialVersionUID = 3606940454221918725L;
    private transient Ehcache cache;
    private final int statisticsAccuracy;
    private final long cacheHits;
    private final long onDiskHits;
    private final long inMemoryHits;
    private final long misses;
    private final long size;

    public Statistics(Ehcache ehcache, int n, long l, long l2, long l3, long l4, long l5) {
        this.statisticsAccuracy = n;
        this.cacheHits = l;
        this.onDiskHits = l2;
        this.inMemoryHits = l3;
        this.misses = l4;
        this.cache = ehcache;
        this.size = l5;
    }

    public void clearStatistics() {
        block3: {
            if (this.cache == null) {
                throw new IllegalStateException("This statistics object no longer references a Cache.");
            }
            try {
                this.cache.clearStatistics();
            }
            catch (IllegalStateException illegalStateException) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.info((Object)("Ignoring call because " + illegalStateException.getMessage()));
            }
        }
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getInMemoryHits() {
        return this.inMemoryHits;
    }

    public long getOnDiskHits() {
        return this.onDiskHits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    public long getObjectCount() {
        return this.size;
    }

    public long getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public String getAssociatedCacheName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return null;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ").append(" name = ").append(this.getAssociatedCacheName()).append(" cacheHits = ").append(this.cacheHits).append(" onDiskHits = ").append(this.onDiskHits).append(" inMemoryHits = ").append(this.inMemoryHits).append(" misses = ").append(this.misses).append(" size = ").append(this.size).append(" ]");
        return stringBuffer.toString();
    }
}

