/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Element
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3343087714201120157L;
    private static final Log LOG = LogFactory.getLog((String)Element.class.getName());
    private static final long ONE_SECOND = 1000L;
    private final Object key;
    private Object value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    private int timeToLive;
    private int timeToIdle;
    private long lastUpdateTime;
    private boolean eternal;
    private boolean lifespanSet;

    public Element(Serializable serializable, Serializable serializable2, long l) {
        this((Object)serializable, (Object)serializable2, l);
    }

    public Element(Object object, Object object2, long l) {
        this.key = object;
        this.value = object2;
        this.version = l;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Element(Serializable serializable, Serializable serializable2) {
        this((Object)serializable, (Object)serializable2, 1L);
    }

    public Element(Object object, Object object2) {
        this(object, object2, 1L);
    }

    public final Serializable getKey() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.key;
        }
        catch (Exception exception) {
            throw new CacheException("Key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectKey() {
        return this.key;
    }

    public final Serializable getValue() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.value;
        }
        catch (Exception exception) {
            throw new CacheException("Value " + this.value + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectValue() {
        return this.value;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Element element = (Element)object;
        if (this.key == null || element.getObjectKey() == null) {
            return false;
        }
        return this.key.equals(element.getObjectKey());
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
        this.lifespanSet = true;
    }

    public void setTimeToIdle(int n) {
        this.timeToIdle = n;
        this.lifespanSet = true;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final void setVersion(long l) {
        this.version = l;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public final long getVersion() {
        return this.version;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    final long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public final void updateUpdateStatistics() {
        this.version = this.lastUpdateTime = System.currentTimeMillis();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.getCreationTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(" ]");
        return stringBuffer.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Element element = new Element(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        element.creationTime = this.creationTime;
        element.lastAccessTime = this.lastAccessTime;
        element.nextToLastAccessTime = this.nextToLastAccessTime;
        element.hitCount = this.hitCount;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deepCopy(Object object) {
        Serializable serializable = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            LOG.error((Object)("Error cloning Element with key " + this.key + " during serialization and deserialization of value"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error((Object)("Error cloning Element with key " + this.key + " during serialization and deserialization of value"));
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error closing Stream");
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSerializedSize() {
        if (!this.isSerializable()) {
            return 0L;
        }
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            long l2 = l = (long)byteArrayOutputStream.size();
            return l2;
        }
        catch (IOException iOException) {
            LOG.debug((Object)("Error measuring element size for element with key " + this.key + ". Cause was: " + iOException.getMessage()));
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error closing ObjectOutputStream");
            }
        }
        return l;
    }

    public final boolean isSerializable() {
        return this.key instanceof Serializable && this.value instanceof Serializable;
    }

    public final boolean isKeySerializable() {
        return this.key instanceof Serializable;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean isExpired() {
        long l;
        if (!this.lifespanSet) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        return l2 > (l = this.getExpirationTime());
    }

    public long getExpirationTime() {
        if (!this.lifespanSet || this.eternal || this.timeToLive == 0 && this.timeToIdle == 0) {
            return Long.MAX_VALUE;
        }
        long l = 0L;
        long l2 = this.creationTime + (long)this.timeToLive * 1000L;
        long l3 = Math.max(this.creationTime, this.nextToLastAccessTime);
        long l4 = l3 + (long)this.timeToIdle * 1000L;
        l = this.timeToLive != 0 && (this.timeToIdle == 0 || this.lastAccessTime == 0L) ? l2 : (this.timeToLive == 0 ? l4 : Math.min(l2, l4));
        return l;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean bl) {
        this.eternal = bl;
        this.lifespanSet = true;
    }

    public boolean isLifespanSet() {
        return this.lifespanSet;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public int getTimeToIdle() {
        return this.timeToIdle;
    }
}

