/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.store.DiskStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheManager {
    public static final List ALL_CACHE_MANAGERS = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog((String)CacheManager.class.getName());
    private static CacheManager singleton;
    protected final Map caches = new HashMap();
    private Ehcache defaultCache;
    private String diskStorePath;
    private CacheManagerEventListener cacheManagerEventListener;
    private Status status = Status.STATUS_UNINITIALISED;
    private CacheManagerPeerProvider cacheManagerPeerProvider;
    private CacheManagerPeerListener cacheManagerPeerListener;
    private Thread shutdownHook;

    public CacheManager(Configuration configuration) throws CacheException {
        this.init(configuration, null, null, null);
    }

    public CacheManager(String string) throws CacheException {
        this.init(null, string, null, null);
    }

    public CacheManager(URL uRL) throws CacheException {
        this.init(null, null, uRL, null);
    }

    public CacheManager(InputStream inputStream) throws CacheException {
        this.init(null, null, null, inputStream);
    }

    public CacheManager() throws CacheException {
        this.init(null, null, null, null);
    }

    private void init(Configuration configuration, String string, URL uRL, InputStream inputStream) {
        Configuration configuration2 = configuration;
        if (configuration == null) {
            configuration2 = this.parseConfiguration(string, uRL, inputStream);
        } else {
            configuration2.setSource("Programmatically configured.");
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, configuration2);
        this.configure(configurationHelper);
        this.addConfiguredCaches(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.init();
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.init();
        }
        this.addShutdownHook();
    }

    private synchronized Configuration parseConfiguration(String string, URL uRL, InputStream inputStream) throws CacheException {
        String string2;
        Configuration configuration;
        this.reinitialisationCheck();
        if (string != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configuring CacheManager from " + string));
            }
            configuration = ConfigurationFactory.parseConfiguration(new File(string));
            string2 = "file located at " + string;
        } else if (uRL != null) {
            configuration = ConfigurationFactory.parseConfiguration(uRL);
            string2 = "URL of " + uRL;
        } else if (inputStream != null) {
            configuration = ConfigurationFactory.parseConfiguration(inputStream);
            string2 = "InputStream " + inputStream;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Configuring ehcache from classpath.");
            }
            configuration = ConfigurationFactory.parseConfiguration();
            string2 = "classpath";
        }
        configuration.setSource(string2);
        return configuration;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListener = configurationHelper.createCacheManagerEventListener();
        this.cacheManagerPeerListener = configurationHelper.createCachePeerListener();
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProvider = configurationHelper.createCachePeerProvider();
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        if (this.diskStorePath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No disk store path defined. Skipping disk store path conflict test.");
            }
            return;
        }
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String string = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.warn((Object)("Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + string + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance."));
            this.diskStorePath = string;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListener == null) {
            return;
        }
        String string = this.cacheManagerPeerListener.getUniqueResourceIdentifier();
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            String string2;
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            CacheManagerPeerListener cacheManagerPeerListener = cacheManager.cacheManagerPeerListener;
            if (cacheManagerPeerListener == null || !string.equals(string2 = cacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
            LOG.warn((Object)("Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + string + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance."));
            this.cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
            break;
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set set = configurationHelper.createCaches();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Ehcache ehcache = (Ehcache)iterator.next();
            this.addCacheNoCheck(ehcache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.caches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with default config");
                }
                singleton = new CacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempting to create an existing singleton. Existing singleton returned.");
            }
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String string) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config file: " + string));
                }
                singleton = new CacheManager(string);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL uRL) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config URL: " + uRL));
                }
                singleton = new CacheManager(uRL);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with InputStream");
                }
                singleton = new CacheManager(inputStream);
            }
            return singleton;
        }
    }

    public synchronized Cache getCache(String string) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return (Cache)this.caches.get(string);
    }

    public synchronized Ehcache getEhcache(String string) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.caches.get(string);
    }

    private void addShutdownHook() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"VM shutting down with the CacheManager still active. Calling shutdown.");
                        }
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        this.shutdownHook = thread;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.start();
            this.shutdownHook = null;
        }
    }

    public synchronized void addCache(String string) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.caches.get(string) != null) {
            throw new ObjectExistsException("Cache " + string + " already exists");
        }
        Ehcache ehcache = null;
        try {
            ehcache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOG.error((Object)("Failure adding cache. Initial cause was " + cloneNotSupportedException.getMessage()), (Throwable)cloneNotSupportedException);
        }
        if (ehcache != null) {
            ehcache.setName(string);
        }
        this.addCache(ehcache);
    }

    public synchronized void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.addCache((Ehcache)cache);
    }

    public synchronized void addCache(Ehcache ehcache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        this.addCacheNoCheck(ehcache);
    }

    private synchronized void addCacheNoCheck(Ehcache ehcache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.caches.get(ehcache.getName()) != null) {
            throw new ObjectExistsException("Cache " + ehcache.getName() + " already exists");
        }
        ehcache.setCacheManager(this);
        ehcache.setDiskStorePath(this.diskStorePath);
        ehcache.initialise();
        try {
            ehcache.bootstrap();
        }
        catch (CacheException cacheException) {
            LOG.warn((Object)("Cache " + ehcache.getName() + "requested bootstrap but a CacheException occured. " + cacheException.getMessage()), (Throwable)cacheException);
        }
        this.caches.put(ehcache.getName(), ehcache);
        if (this.cacheManagerEventListener != null) {
            this.cacheManagerEventListener.notifyCacheAdded(ehcache.getName());
        }
        if (this.cacheManagerPeerListener != null && this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerPeerListener.notifyCacheAdded(ehcache.getName());
        }
    }

    public synchronized boolean cacheExists(String string) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(string) != null;
    }

    public synchronized void removalAll() {
        String[] stringArray = this.getCacheNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.removeCache(string);
        }
    }

    public synchronized void removeCache(String string) throws IllegalStateException {
        this.checkStatus();
        if (string == null || string.length() == 0) {
            return;
        }
        Ehcache ehcache = (Ehcache)this.caches.remove(string);
        if (ehcache != null && ehcache.getStatus().equals(Status.STATUS_ALIVE)) {
            ehcache.dispose();
            if (this.cacheManagerEventListener != null) {
                this.cacheManagerEventListener.notifyCacheRemoved(ehcache.getName());
            }
            if (this.cacheManagerPeerListener != null && this.status.equals(Status.STATUS_ALIVE)) {
                this.cacheManagerPeerListener.notifyCacheRemoved(ehcache.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CacheManager already shutdown");
            }
            return;
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.dispose();
        }
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.dispose();
        }
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            ALL_CACHE_MANAGERS.remove(this);
            Collection collection = this.caches.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Ehcache ehcache = (Ehcache)iterator.next();
                if (ehcache == null) continue;
                ehcache.dispose();
            }
            this.status = Status.STATUS_SHUTDOWN;
            if (this == singleton) {
                singleton = null;
            }
            this.removeShutdownHook();
        }
    }

    public synchronized String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] stringArray = new String[this.caches.size()];
        return this.caches.keySet().toArray(stringArray);
    }

    private void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The CacheManager is not alive.");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] stringArray = this.getCacheNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Clearing all caches");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Ehcache ehcache = this.getEhcache(string);
            ehcache.removeAll();
        }
    }

    public CacheManagerPeerProvider getCachePeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public CacheManagerPeerListener getCachePeerListener() {
        return this.cacheManagerPeerListener;
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListener;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.cacheManagerEventListener = cacheManagerEventListener;
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public synchronized void replaceCacheWithDecoratedCache(Ehcache ehcache, Ehcache ehcache2) throws CacheException {
        if (!ehcache.equals(ehcache2)) {
            throw new CacheException("Cannot replace " + ehcache2.getName() + " It does not equal the incumbent cache.");
        }
        this.caches.remove(ehcache.getName());
        this.caches.put(ehcache.getName(), ehcache2);
    }
}

