/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Ehcache {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final Log LOG = LogFactory.getLog((String)Cache.class.getName());
    private static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private static InetAddress localhost;
    private boolean disabled;
    private String name;
    private DiskStore diskStore;
    private String diskStorePath;
    private Status status;
    private final int maxElementsInMemory;
    private final int maxElementsOnDisk;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    private int statisticsAccuracy;
    private final boolean overflowToDisk;
    private final long diskExpiryThreadIntervalSeconds;
    private final boolean diskPersistent;
    private final boolean eternal;
    private final long timeToLiveSeconds;
    private final long timeToIdleSeconds;
    private int hitCount;
    private int memoryStoreHitCount;
    private int diskStoreHitCount;
    private int missCountNotFound;
    private int missCountExpired;
    private MemoryStore memoryStore;
    private RegisteredEventListeners registeredEventListeners;
    private final String guid;
    private CacheManager cacheManager;
    private BootstrapCacheLoader bootstrapCacheLoader;

    public Cache(String string, int n, boolean bl, boolean bl2, long l, long l2) {
        this(string, n, DEFAULT_MEMORY_STORE_EVICTION_POLICY, bl, null, bl2, l, l2, false, 120L, null, null);
    }

    public Cache(String string, int n, boolean bl, boolean bl2, long l, long l2, boolean bl3, long l3) {
        this(string, n, DEFAULT_MEMORY_STORE_EVICTION_POLICY, bl, null, bl2, l, l2, bl3, l3, null, null);
        LOG.warn((Object)"An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to java.io.tmp when the ehcache-1.1 constructor is used. Please change to the 1.2 constructor");
    }

    public Cache(String string, int n, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean bl, String string2, boolean bl2, long l, long l2, boolean bl3, long l3, RegisteredEventListeners registeredEventListeners) {
        this(string, n, memoryStoreEvictionPolicy, bl, string2, bl2, l, l2, bl3, l3, registeredEventListeners, null);
    }

    public Cache(String string, int n, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean bl, String string2, boolean bl2, long l, long l2, boolean bl3, long l3, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this(string, n, memoryStoreEvictionPolicy, bl, string2, bl2, l, l2, bl3, l3, registeredEventListeners, bootstrapCacheLoader, 0);
    }

    public Cache(String string, int n, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean bl, String string2, boolean bl2, long l, long l2, boolean bl3, long l3, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int n2) {
        String string3 = System.getProperty(NET_SF_EHCACHE_DISABLED);
        if (string3 != null) {
            this.disabled = string3.equalsIgnoreCase("true");
        }
        this.statisticsAccuracy = 0;
        this.guid = localhost + "-" + new UID();
        this.changeStatus(Status.STATUS_UNINITIALISED);
        this.setName(string);
        this.maxElementsInMemory = n;
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
        this.overflowToDisk = bl;
        this.eternal = bl2;
        this.timeToLiveSeconds = l;
        this.timeToIdleSeconds = l2;
        this.diskPersistent = bl3;
        this.maxElementsOnDisk = n2;
        this.diskStorePath = string2 == null ? System.getProperty("java.io.tmpdir") : string2;
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.diskExpiryThreadIntervalSeconds = l3 == 0L ? 120L : l3;
        if (memoryStoreEvictionPolicy == null) {
            this.memoryStoreEvictionPolicy = DEFAULT_MEMORY_STORE_EVICTION_POLICY;
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("Cannot initialise the " + this.name + " cache because its status is not STATUS_UNINITIALISED");
            }
            if (this.maxElementsInMemory == 0 && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cache: " + this.name + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore."));
            }
            if (this.overflowToDisk) {
                this.diskStore = new DiskStore(this, this.diskStorePath);
            }
            this.memoryStore = MemoryStore.create(this, this.diskStore);
            this.changeStatus(Status.STATUS_ALIVE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialised cache: " + this.name));
        }
        if (this.disabled && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Cache: " + this.name + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache."));
        }
    }

    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element, boolean bl) throws IllegalArgumentException, IllegalStateException, CacheException {
        boolean bl2;
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        element.resetAccessStatistics();
        Object object = element.getObjectKey();
        boolean bl3 = bl2 = this.isElementInMemory(object) || this.isElementOnDisk(object);
        if (bl2) {
            element.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
        if (bl2) {
            this.registeredEventListeners.notifyElementUpdated(element, bl);
        } else {
            this.registeredEventListeners.notifyElementPut(element, bl);
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setTimeToLive((int)this.timeToLiveSeconds);
            element.setTimeToIdle((int)this.timeToIdleSeconds);
            element.setEternal(this.eternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
    }

    public final Element get(Serializable serializable) throws IllegalStateException, CacheException {
        return this.get((Object)serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element get(Object object) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(object, true);
            if (element == null && this.overflowToDisk) {
                element = this.searchInDiskStore(object, true);
            }
            if (element == null) {
                ++this.missCountNotFound;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.name + " cache - Miss"));
                }
            } else {
                ++this.hitCount;
            }
        }
        return element;
    }

    public final Element getQuiet(Serializable serializable) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getQuiet(Object object) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(object, false);
            if (element == null && this.overflowToDisk) {
                element = this.searchInDiskStore(object, false);
            }
        }
        return element;
    }

    public final synchronized List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = Arrays.asList(this.memoryStore.getKeyArray());
        arrayList.addAll(list);
        if (this.overflowToDisk) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(list);
            Object[] objectArray = this.diskStore.getKeyArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!hashSet.add(object)) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List list = this.getKeys();
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            Element element = this.getQuiet(e);
            if (element == null) continue;
            arrayList.add(e);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public final synchronized List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = Arrays.asList(this.memoryStore.getKeyArray());
        arrayList.addAll(list);
        if (this.overflowToDisk) {
            List<Object> list2 = Arrays.asList(this.diskStore.getKeyArray());
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private Element searchInMemoryStore(Object object, boolean bl) {
        Element element = bl ? this.memoryStore.get(object) : this.memoryStore.getQuiet(object);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " Memory cache hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(object, true, true, false);
                element = null;
            } else {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Object object, boolean bl) {
        if (!(object instanceof Serializable)) {
            return null;
        }
        Serializable serializable = (Serializable)object;
        Element element = bl ? this.diskStore.get(serializable) : this.diskStore.getQuiet(serializable);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " cache - Disk Store hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(object, true, true, false);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public final boolean remove(Serializable serializable) throws IllegalStateException {
        return this.remove((Object)serializable);
    }

    public final boolean remove(Object object) throws IllegalStateException {
        return this.remove(object, false);
    }

    public final boolean remove(Serializable serializable, boolean bl) throws IllegalStateException {
        return this.remove((Object)serializable, bl);
    }

    public final boolean remove(Object object, boolean bl) throws IllegalStateException {
        return this.remove(object, false, true, bl);
    }

    public final boolean removeQuiet(Serializable serializable) throws IllegalStateException {
        return this.remove(serializable, false, false, false);
    }

    public final boolean removeQuiet(Object object) throws IllegalStateException {
        return this.remove(object, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object object, boolean bl, boolean bl2, boolean bl3) throws IllegalStateException {
        Serializable serializable;
        Element element;
        Element element2;
        this.checkStatus();
        boolean bl4 = false;
        Cache cache = this;
        synchronized (cache) {
            element2 = this.memoryStore.remove(object);
            element = null;
            if (this.overflowToDisk && object instanceof Serializable) {
                serializable = (Serializable)object;
                element = this.diskStore.remove(serializable);
            }
        }
        boolean bl5 = false;
        if (element2 != null) {
            if (bl2) {
                if (bl) {
                    this.registeredEventListeners.notifyElementExpiry(element2, bl3);
                } else {
                    bl5 = true;
                    this.registeredEventListeners.notifyElementRemoved(element2, bl3);
                }
            }
            bl4 = true;
        }
        if (element != null) {
            if (bl) {
                this.registeredEventListeners.notifyElementExpiry(element, bl3);
            } else {
                bl5 = true;
                this.registeredEventListeners.notifyElementRemoved(element, bl3);
            }
            bl4 = true;
        }
        if (!bl && !bl5) {
            serializable = new Element(object, null);
            this.registeredEventListeners.notifyElementRemoved((Element)serializable, bl3);
        }
        return bl4;
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean bl) throws IllegalStateException, CacheException {
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.removeAll();
            if (this.overflowToDisk) {
                this.diskStore.removeAll();
            }
        }
        this.registeredEventListeners.notifyRemoveAll(bl);
    }

    public synchronized void dispose() throws IllegalStateException {
        this.checkStatus();
        this.memoryStore.dispose();
        this.memoryStore = null;
        if (this.overflowToDisk) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.registeredEventListeners.dispose();
        this.changeStatus(Status.STATUS_SHUTDOWN);
    }

    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.memoryStore.flush();
            if (this.overflowToDisk) {
                this.diskStore.flush();
            }
        }
        catch (IOException iOException) {
            throw new CacheException("Unable to flush cache: " + this.name + ". Initial cause was " + iOException.getMessage(), iOException);
        }
    }

    public final synchronized int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.getKeys().size();
    }

    public final synchronized long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.overflowToDisk) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.name + " Cache is not alive.");
        }
    }

    public final int getHitCount() {
        return this.hitCount;
    }

    public final int getMemoryStoreHitCount() {
        return this.memoryStoreHitCount;
    }

    public final int getDiskStoreHitCount() {
        return this.diskStoreHitCount;
    }

    public final int getMissCountNotFound() {
        return this.missCountNotFound;
    }

    public final int getMissCountExpired() {
        return this.missCountExpired;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) throws IllegalArgumentException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Only unitialised caches can have their names set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cache name cannot contain '/' characters.");
        }
        this.name = string;
    }

    public final long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public final long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public final boolean isEternal() {
        return this.eternal;
    }

    public final boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public final int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ").append(" name = ").append(this.name).append(" status = ").append(this.status).append(" eternal = ").append(this.eternal).append(" overflowToDisk = ").append(this.overflowToDisk).append(" maxElementsInMemory = ").append(this.maxElementsInMemory).append(" maxElementsOnDisk = ").append(this.maxElementsOnDisk).append(" memoryStoreEvictionPolicy = ").append(this.memoryStoreEvictionPolicy).append(" timeToLiveSeconds = ").append(this.timeToLiveSeconds).append(" timeToIdleSeconds = ").append(this.timeToIdleSeconds).append(" diskPersistent = ").append(this.diskPersistent).append(" diskExpiryThreadIntervalSeconds = ").append(this.diskExpiryThreadIntervalSeconds).append(this.registeredEventListeners).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            return element.isExpired();
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        Object object;
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache cache = (Cache)super.clone();
        RegisteredEventListeners registeredEventListeners = cache.getCacheEventNotificationService();
        if (registeredEventListeners == null || registeredEventListeners.getCacheEventListeners().size() == 0) {
            cache.registeredEventListeners = new RegisteredEventListeners(cache);
        } else {
            cache.registeredEventListeners = new RegisteredEventListeners(cache);
            object = this.registeredEventListeners.getCacheEventListeners();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                CacheEventListener cacheEventListener2 = (CacheEventListener)cacheEventListener.clone();
                cache.registeredEventListeners.registerListener(cacheEventListener2);
            }
        }
        if (this.bootstrapCacheLoader != null) {
            object = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            cache.setBootstrapCacheLoader((BootstrapCacheLoader)object);
        }
        return cache;
    }

    final DiskStore getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    final MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    public final boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public final long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    public final boolean isElementInMemory(Serializable serializable) {
        return this.isElementInMemory((Object)serializable);
    }

    public final boolean isElementInMemory(Object object) {
        return this.memoryStore.containsKey(object);
    }

    public final boolean isElementOnDisk(Serializable serializable) {
        return this.isElementOnDisk((Object)serializable);
    }

    public final boolean isElementOnDisk(Object object) {
        if (!(object instanceof Serializable)) {
            return false;
        }
        Serializable serializable = (Serializable)object;
        if (!this.overflowToDisk) {
            return false;
        }
        return this.diskStore != null && this.diskStore.containsKey(serializable);
    }

    public final String getGuid() {
        return this.guid;
    }

    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public synchronized void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.hitCount = 0;
        this.memoryStoreHitCount = 0;
        this.diskStoreHitCount = 0;
        this.missCountExpired = 0;
        this.missCountNotFound = 0;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public void setStatisticsAccuracy(int n) {
        this.statisticsAccuracy = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictExpiredElements() {
        Object[] objectArray = this.memoryStore.getKeyArray();
        Cache cache = this;
        synchronized (cache) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.searchInMemoryStore(object, false);
            }
        }
        if (this.overflowToDisk) {
            this.diskStore.expireElements();
        }
    }

    public boolean isKeyInCache(Object object) {
        return this.isElementInMemory(object) || this.isElementOnDisk(object);
    }

    public boolean isValueInCache(Object object) {
        List list = this.getKeys();
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            if (element == null || !element.getObjectValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    public Statistics getStatistics() throws IllegalStateException {
        int n = 0;
        if (this.statisticsAccuracy == 0) {
            n = this.getSize();
        } else if (this.statisticsAccuracy == 1) {
            n = this.getKeysWithExpiryCheck().size();
        } else if (this.statisticsAccuracy == 2) {
            n = this.getKeysNoDuplicateCheck().size();
        }
        return new Statistics(this, this.statisticsAccuracy, this.hitCount, this.diskStoreHitCount, this.memoryStoreHitCount, this.missCountExpired + this.missCountNotFound, n);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.name);
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setDiskStorePath(String string) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A DiskStore path can only be set before the cache is initialized. " + this.name);
        }
        this.diskStorePath = string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache ehcache = (Ehcache)object;
        return this.guid.equals(ehcache.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            LOG.error((Object)("Unable to set localhost. This prevents creation of a GUID. Cause was: " + unknownHostException.getMessage()), (Throwable)unknownHostException);
        }
    }
}

