/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class PartInputStream
extends FilterInputStream {
    private String boundary;
    private byte[] buf = new byte[65536];
    private int count;
    private int pos;
    private boolean eof;

    PartInputStream(ServletInputStream servletInputStream, String string) throws IOException {
        super((InputStream)servletInputStream);
        this.boundary = string;
    }

    private void fill() throws IOException {
        if (this.eof) {
            return;
        }
        if (this.count > 0) {
            if (this.count - this.pos == 2) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                this.count -= this.pos;
                this.pos = 0;
            } else {
                throw new IllegalStateException("fill() detected illegal buffer state");
            }
        }
        int n = 0;
        int n2 = this.boundary.length();
        int n3 = this.buf.length - n2 - 2;
        while (this.count < n3) {
            n = ((ServletInputStream)this.in).readLine(this.buf, this.count, this.buf.length - this.count);
            if (n == -1) {
                throw new IOException("unexpected end of part");
            }
            if (n >= n2) {
                this.eof = true;
                int n4 = 0;
                while (n4 < n2) {
                    if (this.boundary.charAt(n4) != this.buf[this.count + n4]) {
                        this.eof = false;
                        break;
                    }
                    ++n4;
                }
                if (this.eof) break;
            }
            this.count += n;
        }
    }

    public int read() throws IOException {
        if (this.count - this.pos <= 2) {
            this.fill();
            if (this.count - this.pos <= 2) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.count - this.pos - 2;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos - 2;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = Math.min(n2, n4);
        System.arraycopy(this.buf, this.pos, byArray, n, n5);
        this.pos += n5;
        n3 += n5;
        while (n3 < n2) {
            this.fill();
            n4 = this.count - this.pos - 2;
            if (n4 <= 0) {
                return n3;
            }
            n5 = Math.min(n2 - n3, n4);
            System.arraycopy(this.buf, this.pos, byArray, n + n3, n5);
            this.pos += n5;
            n3 += n5;
        }
        return n3;
    }

    public int available() throws IOException {
        int n = this.count - this.pos - 2 + this.in.available();
        return n < 0 ? 0 : n;
    }

    public void close() throws IOException {
        if (!this.eof) {
            while (this.read(this.buf, 0, this.buf.length) != -1) {
            }
        }
    }
}

