/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class ServletUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void returnFile(String string, OutputStream outputStream) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            Object var6_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public static void returnURL(URL uRL, OutputStream outputStream) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void returnURL(URL uRL, Writer writer) throws IOException {
        int n;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        String string = uRLConnection.getContentEncoding();
        BufferedReader bufferedReader = null;
        bufferedReader = string == null ? new BufferedReader(new InputStreamReader(uRL.openStream())) : new BufferedReader(new InputStreamReader(uRL.openStream(), string));
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
    }

    public static String getStackTraceAsString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        throwable.printStackTrace(printWriter);
        return byteArrayOutputStream.toString();
    }

    public static Servlet getServlet(String string, ServletRequest servletRequest, ServletContext servletContext) {
        try {
            Servlet servlet = servletContext.getServlet(string);
            if (servlet != null) {
                return servlet;
            }
            Socket socket = new Socket(servletRequest.getServerName(), servletRequest.getServerPort());
            socket.setSoTimeout(4000);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            printWriter.println("GET /servlet/" + string + " HTTP/1.0");
            printWriter.println();
            try {
                socket.getInputStream().read();
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
            printWriter.close();
            return servletContext.getServlet(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static URL getResource(ServletContext servletContext, String string) throws IOException {
        if (string == null) {
            throw new FileNotFoundException("Requested resource was null (passed in null)");
        }
        if (string.endsWith("/") || string.endsWith("\\") || string.endsWith(".")) {
            throw new MalformedURLException("Path may not end with a slash or dot");
        }
        if (string.indexOf("..") != -1) {
            throw new MalformedURLException("Path may not contain double dots");
        }
        String string2 = string.toUpperCase();
        if (string2.startsWith("/WEB-INF") || string2.startsWith("/META-INF")) {
            throw new MalformedURLException("Path may not begin with /WEB-INF or /META-INF");
        }
        if (string2.endsWith(".JSP")) {
            throw new MalformedURLException("Path may not end with .jsp");
        }
        URL uRL = servletContext.getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException("Requested resource was null (" + string + ")");
        }
        return uRL;
    }
}

