/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.MailPrintStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MailMessage {
    String host;
    String from;
    Vector to;
    Vector cc;
    Hashtable headers;
    MailPrintStream out;
    BufferedReader in;
    Socket socket;

    public MailMessage() throws IOException {
        this("localhost");
    }

    public MailMessage(String string) throws IOException {
        this.host = string;
        this.to = new Vector();
        this.cc = new Vector();
        this.headers = new Hashtable();
        this.setHeader("X-Mailer", "com.oreilly.servlet.MailMessage (www.servlets.com)");
        this.connect();
        this.sendHelo();
    }

    public void from(String string) throws IOException {
        this.sendFrom(string);
        this.from = string;
    }

    public void to(String string) throws IOException {
        this.sendRcpt(string);
        this.to.addElement(string);
    }

    public void cc(String string) throws IOException {
        this.sendRcpt(string);
        this.cc.addElement(string);
    }

    public void bcc(String string) throws IOException {
        this.sendRcpt(string);
    }

    public void setSubject(String string) {
        this.headers.put("Subject", string);
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public PrintStream getPrintStream() throws IOException {
        this.setFromHeader();
        this.setToHeader();
        this.setCcHeader();
        this.sendData();
        this.flushHeaders();
        return this.out;
    }

    void setFromHeader() {
        this.setHeader("From", this.from);
    }

    void setToHeader() {
        this.setHeader("To", this.vectorToList(this.to));
    }

    void setCcHeader() {
        if (!this.cc.isEmpty()) {
            this.setHeader("Cc", this.vectorToList(this.cc));
        }
    }

    String vectorToList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    void flushHeaders() throws IOException {
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.headers.get(string);
            this.out.println(string + ": " + string2);
        }
        this.out.println();
        this.out.flush();
    }

    public void sendAndClose() throws IOException {
        this.sendDot();
        this.disconnect();
    }

    static String sanitizeAddress(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string.charAt(n5);
            if (c == '(') {
                ++n;
                if (n2 == 0) {
                    n3 = n5;
                }
            } else if (c == ')') {
                --n;
                if (n3 == 0) {
                    n2 = n5 + 1;
                }
            } else if (n == 0 && c == '<') {
                n2 = n5 + 1;
            } else if (n == 0 && c == '>') {
                n3 = n5;
            }
            ++n5;
        }
        if (n3 == 0) {
            n3 = n4;
        }
        return string.substring(n2, n3);
    }

    void connect() throws IOException {
        this.socket = new Socket(this.host, 25);
        this.out = new MailPrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.getReady();
    }

    void getReady() throws IOException {
        String string = this.in.readLine();
        int[] nArray = new int[]{220};
        if (!this.isResponseOK(string, nArray)) {
            throw new IOException("Didn't get introduction from server: " + string);
        }
    }

    void sendHelo() throws IOException {
        String string = InetAddress.getLocalHost().getHostName();
        int[] nArray = new int[]{250};
        this.send("HELO " + string, nArray);
    }

    void sendFrom(String string) throws IOException {
        int[] nArray = new int[]{250};
        this.send("MAIL FROM: <" + MailMessage.sanitizeAddress(string) + ">", nArray);
    }

    void sendRcpt(String string) throws IOException {
        int[] nArray = new int[]{250, 251};
        this.send("RCPT TO: <" + MailMessage.sanitizeAddress(string) + ">", nArray);
    }

    void sendData() throws IOException {
        int[] nArray = new int[]{354};
        this.send("DATA", nArray);
    }

    void sendDot() throws IOException {
        int[] nArray = new int[]{250};
        this.send("\r\n.", nArray);
    }

    void sendQuit() throws IOException {
        int[] nArray = new int[]{221};
        this.send("QUIT", nArray);
    }

    void send(String string, int[] nArray) throws IOException {
        this.out.rawPrint(string + "\r\n");
        String string2 = this.in.readLine();
        if (!this.isResponseOK(string2, nArray)) {
            throw new IOException("Unexpected reply to command: " + string + ": " + string2);
        }
    }

    boolean isResponseOK(String string, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (string.startsWith("" + nArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void disconnect() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

