/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.CacheHttpServletResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CacheHttpServlet
extends HttpServlet {
    CacheHttpServletResponse cacheResponse;
    long cacheLastMod = -1L;
    String cacheQueryString = null;
    String cachePathInfo = null;
    String cacheServletPath = null;
    Object lock = new Object();

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (!string.equals("GET")) {
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        long l = this.getLastModified(httpServletRequest);
        if (l == -1L) {
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        if (l / 1000L * 1000L <= httpServletRequest.getDateHeader("If-Modified-Since")) {
            httpServletResponse.setStatus(304);
            return;
        }
        CacheHttpServletResponse cacheHttpServletResponse = null;
        Object object = this.lock;
        synchronized (object) {
            if (l <= this.cacheLastMod && this.cacheResponse.isValid() && this.equal(this.cacheQueryString, httpServletRequest.getQueryString()) && this.equal(this.cachePathInfo, httpServletRequest.getPathInfo()) && this.equal(this.cacheServletPath, httpServletRequest.getServletPath())) {
                cacheHttpServletResponse = this.cacheResponse;
            }
        }
        if (cacheHttpServletResponse != null) {
            cacheHttpServletResponse.writeTo(httpServletResponse);
            return;
        }
        cacheHttpServletResponse = new CacheHttpServletResponse(httpServletResponse);
        super.service(httpServletRequest, (HttpServletResponse)cacheHttpServletResponse);
        Object object2 = this.lock;
        synchronized (object2) {
            this.cacheResponse = cacheHttpServletResponse;
            this.cacheLastMod = l;
            this.cacheQueryString = httpServletRequest.getQueryString();
            this.cachePathInfo = httpServletRequest.getPathInfo();
            this.cacheServletPath = httpServletRequest.getServletPath();
        }
    }

    private boolean equal(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }
}

