/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64Encoder
extends FilterOutputStream {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private int charCount;
    private int carryOver;

    public Base64Encoder(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        if (n < 0) {
            n += 256;
        }
        if (this.charCount % 3 == 0) {
            int n2 = n >> 2;
            this.carryOver = n & 3;
            this.out.write(chars[n2]);
        } else if (this.charCount % 3 == 1) {
            int n3 = (this.carryOver << 4) + (n >> 4) & 0x3F;
            this.carryOver = n & 0xF;
            this.out.write(chars[n3]);
        } else if (this.charCount % 3 == 2) {
            int n4 = (this.carryOver << 2) + (n >> 6) & 0x3F;
            this.out.write(chars[n4]);
            n4 = n & 0x3F;
            this.out.write(chars[n4]);
            this.carryOver = 0;
        }
        ++this.charCount;
        if (this.charCount % 57 == 0) {
            this.out.write(10);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public void close() throws IOException {
        if (this.charCount % 3 == 1) {
            int n = this.carryOver << 4 & 0x3F;
            this.out.write(chars[n]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.charCount % 3 == 2) {
            int n = this.carryOver << 2 & 0x3F;
            this.out.write(chars[n]);
            this.out.write(61);
        }
        super.close();
    }

    public static String encode(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return Base64Encoder.encode(byArray);
    }

    public static String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)((double)byArray.length * 1.37));
        Base64Encoder base64Encoder = new Base64Encoder(byteArrayOutputStream);
        try {
            base64Encoder.write(byArray);
            base64Encoder.close();
            return byteArrayOutputStream.toString("8859_1");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Base64Encoder base64Encoder;
        block7: {
            if (stringArray.length != 1) {
                System.err.println("Usage: java com.oreilly.servlet.Base64Encoder fileToEncode");
                return;
            }
            base64Encoder = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                base64Encoder = new Base64Encoder(System.out);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
                byte[] byArray = new byte[4096];
                while ((n = bufferedInputStream.read(byArray)) != -1) {
                    base64Encoder.write(byArray, 0, n);
                }
                Object var6_5 = null;
                if (bufferedInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (base64Encoder != null) {
                    base64Encoder.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (base64Encoder != null) {
            base64Encoder.close();
        }
    }
}

