/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Base64Decoder
extends FilterInputStream {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] ints = new int[128];
    private int charCount;
    private int carryOver;

    public Base64Decoder(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n;
        do {
            if ((n = this.in.read()) != -1) continue;
            return -1;
        } while (Character.isWhitespace((char)n));
        ++this.charCount;
        if (n == 61) {
            return -1;
        }
        n = ints[n];
        int n2 = (this.charCount - 1) % 4;
        if (n2 == 0) {
            this.carryOver = n & 0x3F;
            return this.read();
        }
        if (n2 == 1) {
            int n3 = (this.carryOver << 2) + (n >> 4) & 0xFF;
            this.carryOver = n & 0xF;
            return n3;
        }
        if (n2 == 2) {
            int n4 = (this.carryOver << 4) + (n >> 2) & 0xFF;
            this.carryOver = n & 3;
            return n4;
        }
        if (n2 == 3) {
            int n5 = (this.carryOver << 6) + n & 0xFF;
            return n5;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length < n2 + n - 1) {
            throw new IOException("The input buffer is too small: " + n2 + " bytes requested starting at offset " + n + " while the buffer " + " is only " + byArray.length + " bytes long.");
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1 && n3 == 0) {
                return -1;
            }
            if (n4 == -1) break;
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public static String decode(String string) {
        return new String(Base64Decoder.decodeToBytes(string));
    }

    public static byte[] decodeToBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Base64Decoder base64Decoder = new Base64Decoder(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)((double)byArray.length * 0.67));
        try {
            int n;
            byte[] byArray2 = new byte[4096];
            while ((n = base64Decoder.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java Base64Decoder fileToDecode");
            return;
        }
        FilterInputStream filterInputStream = null;
        try {
            int n;
            filterInputStream = new Base64Decoder(new BufferedInputStream(new FileInputStream(stringArray[0])));
            byte[] byArray = new byte[4096];
            while ((n = filterInputStream.read(byArray)) != -1) {
                System.out.write(byArray, 0, n);
            }
            Object var5_4 = null;
            if (filterInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (filterInputStream == null) throw throwable;
            filterInputStream.close();
            throw throwable;
        }
        filterInputStream.close();
    }

    static {
        int n = 0;
        while (n < 64) {
            Base64Decoder.ints[Base64Decoder.chars[n]] = n;
            ++n;
        }
    }
}

