/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.Attributes;
import org.apache.commons.attributes.InvalidAttributeTargetError;
import org.apache.commons.attributes.Target;

class Util {
    static /* synthetic */ Class class$org$apache$commons$attributes$Target;

    Util() {
    }

    public static String getSignature(Method method) {
        return method.getName() + "(" + Util.getParameterList(method.getParameterTypes()) + ")";
    }

    public static String getSignature(Constructor constructor) {
        return "(" + Util.getParameterList(constructor.getParameterTypes()) + ")";
    }

    public static String decodedClassName(String string) throws IllegalArgumentException {
        if (!string.startsWith("[")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (string.charAt(n) == '[') {
            stringBuffer.append("[]");
            ++n;
        }
        String string2 = "";
        switch (string.charAt(n)) {
            case 'B': {
                string2 = "byte";
                break;
            }
            case 'C': {
                string2 = "char";
                break;
            }
            case 'D': {
                string2 = "double";
                break;
            }
            case 'F': {
                string2 = "float";
                break;
            }
            case 'I': {
                string2 = "int";
                break;
            }
            case 'J': {
                string2 = "long";
                break;
            }
            case 'L': {
                string2 = string.substring(n + 1, string.length() - 1);
                break;
            }
            case 'S': {
                string2 = "short";
                break;
            }
            case 'Z': {
                string2 = "boolean";
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't decode " + string);
            }
        }
        return string2 + stringBuffer.toString();
    }

    public static String getParameterList(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Util.decodedClassName(classArray[n].getName()));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void checkTarget(int n, Object object, String string) {
        Target target = (Target)Attributes.getAttribute(object.getClass(), class$org$apache$commons$attributes$Target == null ? (class$org$apache$commons$attributes$Target = Util.class$("org.apache.commons.attributes.Target")) : class$org$apache$commons$attributes$Target);
        if (target == null) {
            return;
        }
        if ((target.getFlags() & n) == 0) {
            throw new InvalidAttributeTargetError(object.getClass().getName(), string, target.getFlags());
        }
    }

    public static void checkTarget(int n, Set set, String string) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Util.checkTarget(n, iterator.next(), string);
        }
    }

    public static void validateRepository(Class clazz, AttributeRepositoryClass attributeRepositoryClass) {
        Object object;
        Object object2;
        Object object3;
        Util.checkTarget(1, attributeRepositoryClass.getClassAttributes(), clazz.getName());
        Map map = attributeRepositoryClass.getFieldAttributes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            Util.checkTarget(2, (Collection)map.get(object3), clazz.getName() + "." + (String)object3);
        }
        object3 = attributeRepositoryClass.getConstructorAttributes();
        Iterator iterator2 = object3.keySet().iterator();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            object = (List)object3.get(object2);
            int n = 0;
            while (n < object.size()) {
                switch (n) {
                    case 0: {
                        Util.checkTarget(8, (Collection)object.get(0), clazz.getName() + "." + (String)object2);
                        break;
                    }
                    default: {
                        Util.checkTarget(32, (Collection)object.get(n), "parameter " + n + " of " + clazz.getName() + (String)object2);
                    }
                }
                ++n;
            }
        }
        object2 = attributeRepositoryClass.getMethodAttributes();
        object = object2.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            List list = (List)object2.get(string);
            int n = 0;
            while (n < list.size()) {
                switch (n) {
                    case 0: {
                        Util.checkTarget(4, (Collection)list.get(0), clazz.getName() + "." + string);
                        break;
                    }
                    case 1: {
                        Util.checkTarget(64, (Collection)list.get(1), "return value of " + clazz.getName() + "." + string);
                        break;
                    }
                    default: {
                        Util.checkTarget(16, (Collection)list.get(n), "parameter " + (n - 1) + " of " + clazz.getName() + "." + string);
                    }
                }
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

