/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.Util;

public class RuntimeAttributeRepository
implements AttributeRepositoryClass {
    private boolean sealed = false;
    private final Set classAttributes = new HashSet();
    private final Map fieldAttributes = new HashMap();
    private final Map constructorAttributes = new HashMap();
    private final Map methodAttributes = new HashMap();
    private final Class clazz;

    public RuntimeAttributeRepository(Class clazz) {
        this.clazz = clazz;
    }

    public void addClassAttribute(Object object) {
        this.classAttributes.add(object);
    }

    private void checkSealed() throws IllegalStateException {
        if (this.sealed) {
            throw new IllegalStateException("RuntimeAttributeRepository has been sealed.");
        }
    }

    private List getMethodOrConstructorAttributeBundle(Map map, String string, int n) {
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(string, arrayList);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(new HashSet());
                ++n2;
            }
        }
        return arrayList;
    }

    private List getMethodAttributeBundle(Method method) {
        String string = Util.getSignature(method);
        if (method.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + string + " in " + this.clazz.getName() + ". It is defined in " + method.getDeclaringClass().getName());
        }
        return this.getMethodOrConstructorAttributeBundle(this.methodAttributes, string, method.getParameterTypes().length + 2);
    }

    private List getConstructorAttributeBundle(Constructor constructor) {
        String string = Util.getSignature(constructor);
        if (constructor.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + string + " in " + this.clazz.getName() + ". It is defined in " + constructor.getDeclaringClass().getName());
        }
        return this.getMethodOrConstructorAttributeBundle(this.constructorAttributes, string, constructor.getParameterTypes().length + 1);
    }

    public void addFieldAttribute(String string, Object object) throws NoSuchFieldException, SecurityException {
        this.addFieldAttribute(this.clazz.getDeclaredField(string), object);
    }

    public void addFieldAttribute(Field field, Object object) {
        this.checkSealed();
        String string = field.getName();
        if (field.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + string + " in " + this.clazz.getName() + ". It is defined in " + field.getDeclaringClass().getName());
        }
        HashSet<Object> hashSet = (HashSet<Object>)this.fieldAttributes.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.fieldAttributes.put(string, hashSet);
        }
        hashSet.add(object);
    }

    public void addConstructorAttribute(Class[] classArray, Object object) throws NoSuchMethodException, SecurityException {
        this.addConstructorAttribute(this.clazz.getDeclaredConstructor(classArray), object);
    }

    public void addConstructorAttribute(Constructor constructor, Object object) {
        this.checkSealed();
        List list = this.getConstructorAttributeBundle(constructor);
        Set set = (Set)list.get(0);
        set.add(object);
    }

    public void addMethodAttribute(String string, Class[] classArray, Object object) throws NoSuchMethodException, SecurityException {
        this.addMethodAttribute(this.clazz.getDeclaredMethod(string, classArray), object);
    }

    public void addMethodAttribute(Method method, Object object) {
        this.checkSealed();
        List list = this.getMethodAttributeBundle(method);
        Set set = (Set)list.get(0);
        set.add(object);
    }

    public void addParameterAttribute(Class[] classArray, int n, Object object) throws NoSuchMethodException, SecurityException {
        this.addParameterAttribute(this.clazz.getDeclaredConstructor(classArray), n, object);
    }

    public void addParameterAttribute(Constructor constructor, int n, Object object) {
        this.checkSealed();
        List list = this.getConstructorAttributeBundle(constructor);
        Set set = (Set)list.get(n + 1);
        set.add(object);
    }

    public void addParameterAttribute(String string, Class[] classArray, int n, Object object) throws NoSuchMethodException, SecurityException {
        this.addParameterAttribute(this.clazz.getDeclaredMethod(string, classArray), n, object);
    }

    public void addParameterAttribute(Method method, int n, Object object) {
        this.checkSealed();
        List list = this.getMethodAttributeBundle(method);
        Set set = (Set)list.get(n + 2);
        set.add(object);
    }

    public void addReturnAttribute(String string, Class[] classArray, Object object) throws NoSuchMethodException, SecurityException {
        this.addReturnAttribute(this.clazz.getDeclaredMethod(string, classArray), object);
    }

    public void addReturnAttribute(Method method, Object object) {
        this.checkSealed();
        List list = this.getMethodAttributeBundle(method);
        Set set = (Set)list.get(1);
        set.add(object);
    }

    public Class getDefinedClass() {
        return this.clazz;
    }

    public Set getClassAttributes() {
        return this.classAttributes;
    }

    public Map getFieldAttributes() {
        return this.fieldAttributes;
    }

    public Map getMethodAttributes() {
        return this.methodAttributes;
    }

    public Map getConstructorAttributes() {
        return this.constructorAttributes;
    }

    public void seal() {
        this.sealed = true;
    }
}

