/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.CachedRepository;
import org.apache.commons.attributes.CircularDependencyError;
import org.apache.commons.attributes.DefaultCachedRepository;
import org.apache.commons.attributes.EmptyAttributeRepositoryClass;
import org.apache.commons.attributes.MultipleAttributesError;
import org.apache.commons.attributes.RepositoryError;
import org.apache.commons.attributes.RuntimeAttributeRepository;
import org.apache.commons.attributes.Util;

public class Attributes {
    private static final Map classRepositories = new WeakHashMap();
    private static List initList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized CachedRepository getCachedRepository(Class clazz) throws RepositoryError, CircularDependencyError {
        if (classRepositories.containsKey(clazz)) {
            CachedRepository cachedRepository = (CachedRepository)classRepositories.get(clazz);
            if (cachedRepository == null) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(initList);
                throw new CircularDependencyError(clazz.getName(), arrayList);
            }
            return cachedRepository;
        }
        DefaultCachedRepository defaultCachedRepository = null;
        initList.add(clazz.getName());
        try {
            classRepositories.put(clazz, null);
            Class<?> clazz2 = null;
            AttributeRepositoryClass attributeRepositoryClass = EmptyAttributeRepositoryClass.INSTANCE;
            try {
                clazz2 = Class.forName(clazz.getName() + "$__attributeRepository", true, clazz.getClassLoader());
                attributeRepositoryClass = (AttributeRepositoryClass)clazz2.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                attributeRepositoryClass = EmptyAttributeRepositoryClass.INSTANCE;
            }
            catch (InstantiationException instantiationException) {
                throw new RepositoryError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RepositoryError(illegalAccessException);
            }
            defaultCachedRepository = new DefaultCachedRepository(clazz, attributeRepositoryClass);
            classRepositories.put(clazz, defaultCachedRepository);
            if (attributeRepositoryClass != null) {
                Util.validateRepository(clazz, attributeRepositoryClass);
            }
            Object var8_9 = null;
            initList.remove(initList.size() - 1);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            initList.remove(initList.size() - 1);
            throw throwable;
        }
        return defaultCachedRepository;
    }

    private static Object getAttribute(Collection collection, Class clazz) throws MultipleAttributesError {
        Object var2_2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() != clazz) continue;
            if (var2_2 == null) {
                var2_2 = e;
                continue;
            }
            throw new MultipleAttributesError(clazz.getName());
        }
        return var2_2;
    }

    public static Object getAttribute(Class clazz, Class clazz2) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(clazz), clazz2);
    }

    public static Object getAttribute(Field field, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(field), clazz);
    }

    public static Object getAttribute(Constructor constructor, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(constructor), clazz);
    }

    public static Object getAttribute(Method method, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(method), clazz);
    }

    public static Object getParameterAttribute(Method method, int n, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(method, n), clazz);
    }

    public static Object getParameterAttribute(Constructor constructor, int n, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(constructor, n), clazz);
    }

    public static Object getReturnAttribute(Method method, Class clazz) throws RepositoryError, MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getReturnAttributes(method), clazz);
    }

    public static Collection getAttributes(Class clazz) throws RepositoryError {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return Attributes.getCachedRepository(clazz).getAttributes();
    }

    public static Collection getAttributes(Method method) throws RepositoryError {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return Attributes.getCachedRepository(method.getDeclaringClass()).getAttributes(method);
    }

    public static Collection getParameterAttributes(Method method, int n) throws RepositoryError {
        return Attributes.getCachedRepository(method.getDeclaringClass()).getParameterAttributes(method, n);
    }

    public static Collection getParameterAttributes(Constructor constructor, int n) throws RepositoryError {
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        return Attributes.getCachedRepository(constructor.getDeclaringClass()).getParameterAttributes(constructor, n);
    }

    public static Collection getReturnAttributes(Method method) throws RepositoryError {
        if (method == null) {
            throw new NullPointerException("method");
        }
        return Attributes.getCachedRepository(method.getDeclaringClass()).getReturnAttributes(method);
    }

    public static Collection getAttributes(Field field) throws RepositoryError {
        if (field == null) {
            throw new NullPointerException("field");
        }
        return Attributes.getCachedRepository(field.getDeclaringClass()).getAttributes(field);
    }

    public static Collection getAttributes(Constructor constructor) throws RepositoryError {
        if (constructor == null) {
            throw new NullPointerException("cons");
        }
        return Attributes.getCachedRepository(constructor.getDeclaringClass()).getAttributes(constructor);
    }

    private static Collection getAttributes(Collection collection, Class clazz) {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() != clazz) continue;
            hashSet.add(e);
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public static Collection getAttributes(Class clazz, Class clazz2) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(clazz), clazz2);
    }

    public static Collection getAttributes(Field field, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(field), clazz);
    }

    public static Collection getAttributes(Constructor constructor, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(constructor), clazz);
    }

    public static Collection getAttributes(Method method, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getAttributes(method), clazz);
    }

    public static Collection getParameterAttributes(Method method, int n, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getParameterAttributes(method, n), clazz);
    }

    public static Collection getParameterAttributes(Constructor constructor, int n, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getParameterAttributes(constructor, n), clazz);
    }

    public static Collection getReturnAttributes(Method method, Class clazz) throws RepositoryError {
        return Attributes.getAttributes(Attributes.getReturnAttributes(method), clazz);
    }

    private static boolean hasAttributeType(Collection collection, Class clazz) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttributeType(Class clazz, Class clazz2) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(clazz), clazz2);
    }

    public static boolean hasAttributeType(Field field, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(field), clazz);
    }

    public static boolean hasAttributeType(Constructor constructor, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(constructor), clazz);
    }

    public static boolean hasAttributeType(Method method, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getAttributes(method), clazz);
    }

    public static boolean hasParameterAttributeType(Method method, int n, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(method, n), clazz);
    }

    public static boolean hasParameterAttributeType(Constructor constructor, int n, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(constructor, n), clazz);
    }

    public static boolean hasReturnAttributeType(Method method, Class clazz) throws RepositoryError {
        return Attributes.hasAttributeType(Attributes.getReturnAttributes(method), clazz);
    }

    private static boolean hasAttribute(Collection collection, Object object) throws RepositoryError {
        return collection.contains(object);
    }

    public static boolean hasAttribute(Class clazz, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(clazz), object);
    }

    public static boolean hasAttribute(Field field, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(field), object);
    }

    public static boolean hasAttribute(Constructor constructor, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(constructor), object);
    }

    public static boolean hasAttribute(Method method, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getAttributes(method), object);
    }

    public static boolean hasParameterAttribute(Method method, int n, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(method, n), object);
    }

    public static boolean hasParameterAttribute(Constructor constructor, int n, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(constructor, n), object);
    }

    public static boolean hasReturnAttribute(Method method, Object object) throws RepositoryError {
        return Attributes.hasAttribute(Attributes.getReturnAttributes(method), object);
    }

    public static synchronized void setAttributes(RuntimeAttributeRepository runtimeAttributeRepository) throws IllegalStateException {
        runtimeAttributeRepository.seal();
        Class clazz = runtimeAttributeRepository.getDefinedClass();
        if (classRepositories.get(clazz) != null) {
            throw new IllegalStateException(clazz.getName());
        }
        Util.validateRepository(clazz, runtimeAttributeRepository);
        DefaultCachedRepository defaultCachedRepository = new DefaultCachedRepository(clazz, runtimeAttributeRepository);
        classRepositories.put(clazz, defaultCachedRepository);
    }
}

