/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.attributes.AttributeUtil;
import org.apache.commons.attributes.Attributes;

public class AttributeIndex {
    private final HashMap index = new HashMap();
    private final ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$commons$attributes$Indexed;

    public AttributeIndex(ClassLoader classLoader) throws Exception {
        Object object;
        this.classLoader = classLoader;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/attrs.index");
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.loadFromURL((URL)object);
        }
        object = this.index.values().iterator();
        while (object.hasNext()) {
            ((IndexNode)object.next()).seal();
        }
    }

    private IndexNode getNode(Class clazz) {
        IndexNode indexNode = (IndexNode)this.index.get(clazz.getName());
        if (indexNode == null) {
            indexNode = new IndexNode();
            this.index.put(clazz.getName(), indexNode);
        }
        return indexNode;
    }

    private void addIndex(Collection collection, Class clazz) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).classes.add(clazz);
        }
    }

    private void addIndex(Collection collection, Field field) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).fields.add(field);
        }
    }

    private void addIndex(Collection collection, Method method) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).methods.add(method);
        }
    }

    private void addIndex(Collection collection, Constructor constructor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).constructors.add(constructor);
        }
    }

    private void addReturnIndex(Collection collection, Method method) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).returnValues.add(method);
        }
    }

    private void addIndex(Collection collection, Method method, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).methodParameters.add(new MethodParameter(method, n));
        }
    }

    private void addIndex(Collection collection, Constructor constructor, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.getNode(iterator.next().getClass()).constructorParameters.add(new ConstructorParameter(constructor, n));
        }
    }

    private void addClass(String string) throws Exception {
        int n;
        Class<?> clazz = this.classLoader.loadClass(string);
        Collection collection = Attributes.getAttributes(clazz);
        collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? (class$org$apache$commons$attributes$Indexed = AttributeIndex.class$("org.apache.commons.attributes.Indexed")) : class$org$apache$commons$attributes$Indexed);
        this.addIndex(collection, clazz);
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            collection = Attributes.getAttributes(fieldArray[n2]);
            collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(collection, fieldArray[n2]);
            ++n2;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n3 = 0;
        while (n3 < methodArray.length) {
            collection = Attributes.getAttributes(methodArray[n3]);
            collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(collection, methodArray[n3]);
            collection = Attributes.getReturnAttributes(methodArray[n3]);
            collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addReturnIndex(collection, methodArray[n3]);
            int n4 = methodArray[n3].getParameterTypes().length;
            n = 0;
            while (n < n4) {
                collection = Attributes.getParameterAttributes(methodArray[n3], n);
                collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
                this.addIndex(collection, methodArray[n3], n);
                ++n;
            }
            ++n3;
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        n = 0;
        while (n < constructorArray.length) {
            collection = Attributes.getAttributes(constructorArray[n]);
            collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(collection, constructorArray[n]);
            int n5 = constructorArray[n].getParameterTypes().length;
            int n6 = 0;
            while (n6 < n5) {
                collection = Attributes.getParameterAttributes(constructorArray[n], n6);
                collection = AttributeUtil.getObjectsWithAttributeType(collection, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
                this.addIndex(collection, constructorArray[n], n6);
                ++n6;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromURL(URL uRL) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        try {
            Object var4_4 = null;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("Class: ")) continue;
                String string2 = string.substring("Class: ".length()).trim();
                this.addClass(string2);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    public Collection getClassesWithAttribute(String string) {
        if (this.index.containsKey(string)) {
            Collection collection = ((IndexNode)this.index.get((Object)string)).classes;
            Iterator iterator = collection.iterator();
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            while (iterator.hasNext()) {
                arrayList.add(((Class)iterator.next()).getName().replace('$', '.'));
            }
            return arrayList;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getClassesWithAttribute(Class clazz) {
        return this.getClassesWithAttribute(clazz.getName());
    }

    public Collection getClasses(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).classes;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethods(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).methods;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethodsReturning(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).returnValues;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getFields(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).fields;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getConstructors(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).constructors;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getConstructorParameters(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).constructorParameters;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethodParameters(Class clazz) {
        if (this.index.containsKey(clazz.getName())) {
            return ((IndexNode)this.index.get((Object)clazz.getName())).methodParameters;
        }
        return Collections.EMPTY_SET;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConstructorParameter {
        private final Constructor ctor;
        private final int index;

        public ConstructorParameter(Constructor constructor, int n) {
            this.ctor = constructor;
            this.index = n;
        }

        public Constructor getConstructor() {
            return this.ctor;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof ConstructorParameter && this.ctor.equals(((ConstructorParameter)object).ctor) && this.index == ((ConstructorParameter)object).index;
        }

        public int hashCode() {
            return this.ctor.hashCode() + this.index;
        }

        public String toString() {
            return this.ctor.toString() + ":" + this.index;
        }
    }

    private static class IndexNode {
        public Collection classes = new HashSet();
        public Collection fields = new HashSet();
        public Collection methods = new HashSet();
        public Collection constructors = new HashSet();
        public Collection returnValues = new HashSet();
        public Collection constructorParameters = new HashSet();
        public Collection methodParameters = new HashSet();

        private IndexNode() {
        }

        public void seal() {
            this.classes = this.seal(this.classes);
            this.fields = this.seal(this.fields);
            this.methods = this.seal(this.methods);
            this.constructors = this.seal(this.constructors);
            this.returnValues = this.seal(this.returnValues);
            this.constructorParameters = this.seal(this.constructorParameters);
            this.methodParameters = this.seal(this.methodParameters);
        }

        private Collection seal(Collection collection) {
            return Collections.unmodifiableCollection(collection);
        }
    }

    public static class MethodParameter {
        private final Method method;
        private final int index;

        public MethodParameter(Method method, int n) {
            this.method = method;
            this.index = n;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof MethodParameter && this.method.equals(((MethodParameter)object).method) && this.index == ((MethodParameter)object).index;
        }

        public int hashCode() {
            return this.method.hashCode() + this.index;
        }

        public String toString() {
            return this.method.toString() + ":" + this.index;
        }
    }
}

