/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    protected static final QName ERROR_QNAME = QName.get("error");
    protected static final QName FATALERROR_QNAME = QName.get("fatalError");
    protected static final QName WARNING_QNAME = QName.get("warning");
    private Element errors;
    private QName errorQName = ERROR_QNAME;
    private QName fatalErrorQName = FATALERROR_QNAME;
    private QName warningQName = WARNING_QNAME;

    public XMLErrorHandler() {
        this.errors = DocumentHelper.createElement("errors");
    }

    public XMLErrorHandler(Element element) {
        this.errors = element;
    }

    public void error(SAXParseException sAXParseException) {
        Element element = this.errors.addElement(this.errorQName);
        this.addException(element, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        Element element = this.errors.addElement(this.fatalErrorQName);
        this.addException(element, sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        Element element = this.errors.addElement(this.warningQName);
        this.addException(element, sAXParseException);
    }

    public Element getErrors() {
        return this.errors;
    }

    public void setErrors(Element element) {
        this.errors = element;
    }

    public QName getErrorQName() {
        return this.errorQName;
    }

    public void setErrorQName(QName qName) {
        this.errorQName = qName;
    }

    public QName getFatalErrorQName() {
        return this.fatalErrorQName;
    }

    public void setFatalErrorQName(QName qName) {
        this.fatalErrorQName = qName;
    }

    public QName getWarningQName() {
        return this.warningQName;
    }

    public void setWarningQName(QName qName) {
        this.warningQName = qName;
    }

    protected void addException(Element element, SAXParseException sAXParseException) {
        String string;
        element.addAttribute("column", Integer.toString(sAXParseException.getColumnNumber()));
        element.addAttribute("line", Integer.toString(sAXParseException.getLineNumber()));
        String string2 = sAXParseException.getPublicId();
        if (string2 != null && string2.length() > 0) {
            element.addAttribute("publicID", string2);
        }
        if ((string = sAXParseException.getSystemId()) != null && string.length() > 0) {
            element.addAttribute("systemID", string);
        }
        element.addText(sAXParseException.getMessage());
    }
}

