/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import java.util.Comparator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;

public class NodeComparator
implements Comparator {
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Node) {
            if (object2 instanceof Node) {
                return this.compare((Node)object, (Node)object2);
            }
            return 1;
        }
        if (object2 instanceof Node) {
            return -1;
        }
        if (object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2);
        }
        String string = object.getClass().getName();
        String string2 = object2.getClass().getName();
        return string.compareTo(string2);
    }

    public int compare(Node node, Node node2) {
        short s;
        short s2 = node.getNodeType();
        int n = s2 - (s = node2.getNodeType());
        if (n != 0) {
            return n;
        }
        switch (s2) {
            case 1: {
                return this.compare((Element)node, (Element)node2);
            }
            case 9: {
                return this.compare((Document)node, (Document)node2);
            }
            case 2: {
                return this.compare((Attribute)node, (Attribute)node2);
            }
            case 3: {
                return this.compare((Text)node, (Text)node2);
            }
            case 4: {
                return this.compare((CDATA)node, (CDATA)node2);
            }
            case 5: {
                return this.compare((Entity)node, (Entity)node2);
            }
            case 7: {
                return this.compare((ProcessingInstruction)node, (ProcessingInstruction)node2);
            }
            case 8: {
                return this.compare((Comment)node, (Comment)node2);
            }
            case 10: {
                return this.compare((DocumentType)node, (DocumentType)node2);
            }
            case 13: {
                return this.compare((Namespace)node, (Namespace)node2);
            }
        }
        throw new RuntimeException("Invalid node types. node1: " + node + " and node2: " + node2);
    }

    public int compare(Document document, Document document2) {
        int n = this.compare(document.getDocType(), document2.getDocType());
        if (n == 0) {
            n = this.compareContent(document, document2);
        }
        return n;
    }

    public int compare(Element element, Element element2) {
        int n;
        int n2;
        int n3 = this.compare(element.getQName(), element2.getQName());
        if (n3 == 0 && (n3 = (n2 = element.attributeCount()) - (n = element2.attributeCount())) == 0) {
            for (int i = 0; i < n2; ++i) {
                Attribute attribute;
                Attribute attribute2 = element.attribute(i);
                n3 = this.compare(attribute2, attribute = element2.attribute(attribute2.getQName()));
                if (n3 == 0) continue;
                return n3;
            }
            n3 = this.compareContent(element, element2);
        }
        return n3;
    }

    public int compare(Attribute attribute, Attribute attribute2) {
        int n = this.compare(attribute.getQName(), attribute2.getQName());
        if (n == 0) {
            n = this.compare(attribute.getValue(), attribute2.getValue());
        }
        return n;
    }

    public int compare(QName qName, QName qName2) {
        int n = this.compare(qName.getNamespaceURI(), qName2.getNamespaceURI());
        if (n == 0) {
            n = this.compare(qName.getQualifiedName(), qName2.getQualifiedName());
        }
        return n;
    }

    public int compare(Namespace namespace, Namespace namespace2) {
        int n = this.compare(namespace.getURI(), namespace2.getURI());
        if (n == 0) {
            n = this.compare(namespace.getPrefix(), namespace2.getPrefix());
        }
        return n;
    }

    public int compare(CharacterData characterData, CharacterData characterData2) {
        return this.compare(characterData.getText(), characterData2.getText());
    }

    public int compare(DocumentType documentType, DocumentType documentType2) {
        if (documentType == documentType2) {
            return 0;
        }
        if (documentType == null) {
            return -1;
        }
        if (documentType2 == null) {
            return 1;
        }
        int n = this.compare(documentType.getPublicID(), documentType2.getPublicID());
        if (n == 0 && (n = this.compare(documentType.getSystemID(), documentType2.getSystemID())) == 0) {
            n = this.compare(documentType.getName(), documentType2.getName());
        }
        return n;
    }

    public int compare(Entity entity, Entity entity2) {
        int n = this.compare(entity.getName(), entity2.getName());
        if (n == 0) {
            n = this.compare(entity.getText(), entity2.getText());
        }
        return n;
    }

    public int compare(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        int n = this.compare(processingInstruction.getTarget(), processingInstruction2.getTarget());
        if (n == 0) {
            n = this.compare(processingInstruction.getText(), processingInstruction2.getText());
        }
        return n;
    }

    public int compareContent(Branch branch, Branch branch2) {
        int n;
        int n2 = branch.nodeCount();
        int n3 = n2 - (n = branch2.nodeCount());
        if (n3 == 0) {
            Node node;
            Node node2;
            for (int i = 0; i < n2 && (n3 = this.compare(node2 = branch.node(i), node = branch2.node(i))) == 0; ++i) {
            }
        }
        return n3;
    }

    public int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }
}

