/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.DefaultElement;

public class IndexedElement
extends DefaultElement {
    private Map elementIndex;
    private Map attributeIndex;

    public IndexedElement(String string) {
        super(string);
    }

    public IndexedElement(QName qName) {
        super(qName);
    }

    public IndexedElement(QName qName, int n) {
        super(qName, n);
    }

    public Attribute attribute(String string) {
        return (Attribute)this.attributeIndex().get(string);
    }

    public Attribute attribute(QName qName) {
        return (Attribute)this.attributeIndex().get(qName);
    }

    public Element element(String string) {
        return this.asElement(this.elementIndex().get(string));
    }

    public Element element(QName qName) {
        return this.asElement(this.elementIndex().get(qName));
    }

    public List elements(String string) {
        return this.asElementList(this.elementIndex().get(string));
    }

    public List elements(QName qName) {
        return this.asElementList(this.elementIndex().get(qName));
    }

    protected Element asElement(Object object) {
        List list;
        if (object instanceof Element) {
            return (Element)object;
        }
        if (object != null && (list = (List)object).size() >= 1) {
            return (Element)list.get(0);
        }
        return null;
    }

    protected List asElementList(Object object) {
        if (object instanceof Element) {
            return this.createSingleResultList(object);
        }
        if (object != null) {
            List list = (List)object;
            BackedList backedList = this.createResultList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                backedList.addLocal(list.get(i));
            }
            return backedList;
        }
        return this.createEmptyList();
    }

    protected Iterator asElementIterator(Object object) {
        return this.asElementList(object).iterator();
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (this.elementIndex != null && node instanceof Element) {
            this.addToElementIndex((Element)node);
        } else if (this.attributeIndex != null && node instanceof Attribute) {
            this.addToAttributeIndex((Attribute)node);
        }
    }

    protected boolean removeNode(Node node) {
        if (super.removeNode(node)) {
            if (this.elementIndex != null && node instanceof Element) {
                this.removeFromElementIndex((Element)node);
            } else if (this.attributeIndex != null && node instanceof Attribute) {
                this.removeFromAttributeIndex((Attribute)node);
            }
            return true;
        }
        return false;
    }

    protected Map attributeIndex() {
        if (this.attributeIndex == null) {
            this.attributeIndex = this.createAttributeIndex();
            Iterator iterator = this.attributeIterator();
            while (iterator.hasNext()) {
                this.addToAttributeIndex((Attribute)iterator.next());
            }
        }
        return this.attributeIndex;
    }

    protected Map elementIndex() {
        if (this.elementIndex == null) {
            this.elementIndex = this.createElementIndex();
            Iterator iterator = this.elementIterator();
            while (iterator.hasNext()) {
                this.addToElementIndex((Element)iterator.next());
            }
        }
        return this.elementIndex;
    }

    protected Map createAttributeIndex() {
        Map map = this.createIndex();
        return map;
    }

    protected Map createElementIndex() {
        Map map = this.createIndex();
        return map;
    }

    protected void addToElementIndex(Element element) {
        QName qName = element.getQName();
        String string = qName.getName();
        this.addToElementIndex(qName, element);
        this.addToElementIndex(string, element);
    }

    protected void addToElementIndex(Object object, Element element) {
        Object v = this.elementIndex.get(object);
        if (v == null) {
            this.elementIndex.put(object, element);
        } else if (v instanceof List) {
            List list = (List)v;
            list.add(element);
        } else {
            List list = this.createList();
            list.add(v);
            list.add(element);
            this.elementIndex.put(object, list);
        }
    }

    protected void removeFromElementIndex(Element element) {
        QName qName = element.getQName();
        String string = qName.getName();
        this.removeFromElementIndex(qName, element);
        this.removeFromElementIndex(string, element);
    }

    protected void removeFromElementIndex(Object object, Element element) {
        Object v = this.elementIndex.get(object);
        if (v instanceof List) {
            List list = (List)v;
            list.remove(element);
        } else {
            this.elementIndex.remove(object);
        }
    }

    protected void addToAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        String string = qName.getName();
        this.addToAttributeIndex(qName, attribute);
        this.addToAttributeIndex(string, attribute);
    }

    protected void addToAttributeIndex(Object object, Attribute attribute) {
        Object v = this.attributeIndex.get(object);
        if (v != null) {
            this.attributeIndex.put(object, attribute);
        }
    }

    protected void removeFromAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        String string = qName.getName();
        this.removeFromAttributeIndex(qName, attribute);
        this.removeFromAttributeIndex(string, attribute);
    }

    protected void removeFromAttributeIndex(Object object, Attribute attribute) {
        Object v = this.attributeIndex.get(object);
        if (v != null && v.equals(attribute)) {
            this.attributeIndex.remove(object);
        }
    }

    protected Map createIndex() {
        return new HashMap();
    }

    protected List createList() {
        return new ArrayList();
    }
}

