/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.NamespaceStack;
import org.dom4j.tree.SingleIterator;
import org.xml.sax.Attributes;

public abstract class AbstractElement
extends AbstractBranch
implements Element {
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    protected static final List EMPTY_LIST = Collections.EMPTY_LIST;
    protected static final Iterator EMPTY_ITERATOR = EMPTY_LIST.iterator();
    protected static final boolean VERBOSE_TOSTRING = false;
    protected static final boolean USE_STRINGVALUE_SEPARATOR = false;

    public short getNodeType() {
        return 1;
    }

    public boolean isRootElement() {
        Element element;
        Document document = this.getDocument();
        return document != null && (element = document.getRootElement()) == this;
    }

    public void setName(String string) {
        this.setQName(this.getDocumentFactory().createQName(string));
    }

    public void setNamespace(Namespace namespace) {
        this.setQName(this.getDocumentFactory().createQName(this.getName(), namespace));
    }

    public String getXPathNameStep() {
        String string = this.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return this.getName();
        }
        String string2 = this.getNamespacePrefix();
        if (string2 == null || string2.length() == 0) {
            return "*[name()='" + this.getName() + "']";
        }
        return this.getQualifiedName();
    }

    public String getPath(Element element) {
        if (this == element) {
            return ".";
        }
        Element element2 = this.getParent();
        if (element2 == null) {
            return "/" + this.getXPathNameStep();
        }
        if (element2 == element) {
            return this.getXPathNameStep();
        }
        return element2.getPath(element) + "/" + this.getXPathNameStep();
    }

    public String getUniquePath(Element element) {
        int n;
        Element element2 = this.getParent();
        if (element2 == null) {
            return "/" + this.getXPathNameStep();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (element2 != element) {
            stringBuffer.append(element2.getUniquePath(element));
            stringBuffer.append("/");
        }
        stringBuffer.append(this.getXPathNameStep());
        List list = element2.elements(this.getQName());
        if (list.size() > 1 && (n = list.indexOf(this)) >= 0) {
            stringBuffer.append("[");
            stringBuffer.append(Integer.toString(++n));
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String asXML() {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter(stringWriter, new OutputFormat());
            xMLWriter.write(this);
            xMLWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while generating textual representation: " + iOException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(writer, new OutputFormat());
        xMLWriter.write(this);
    }

    public void accept(Visitor visitor) {
        Node node;
        int n;
        visitor.visit(this);
        int n2 = this.attributeCount();
        for (n = 0; n < n2; ++n) {
            node = this.attribute(n);
            visitor.visit((Attribute)node);
        }
        n2 = this.nodeCount();
        for (n = 0; n < n2; ++n) {
            node = this.node(n);
            node.accept(visitor);
        }
    }

    public String toString() {
        String string = this.getNamespaceURI();
        if (string != null && string.length() > 0) {
            return super.toString() + " [Element: <" + this.getQualifiedName() + " uri: " + string + " attributes: " + this.attributeList() + "/>]";
        }
        return super.toString() + " [Element: <" + this.getQualifiedName() + " attributes: " + this.attributeList() + "/>]";
    }

    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    public String getName() {
        return this.getQName().getName();
    }

    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    public Object getData() {
        return this.getText();
    }

    public void setData(Object object) {
    }

    public Node node(int n) {
        if (n >= 0) {
            List list = this.contentList();
            if (n >= list.size()) {
                return null;
            }
            Object e = list.get(n);
            if (e != null) {
                if (e instanceof Node) {
                    return (Node)e;
                }
                return this.getDocumentFactory().createText(e.toString());
            }
        }
        return null;
    }

    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    public int nodeCount() {
        return this.contentList().size();
    }

    public Iterator nodeIterator() {
        return this.contentList().iterator();
    }

    public Element element(String string) {
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            Object e = list.get(i);
            if (!(e instanceof Element) || !string.equals((element = (Element)e).getName())) continue;
            return element;
        }
        return null;
    }

    public Element element(QName qName) {
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            Object e = list.get(i);
            if (!(e instanceof Element) || !qName.equals((element = (Element)e).getQName())) continue;
            return element;
        }
        return null;
    }

    public Element element(String string, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(string, namespace));
    }

    public List elements() {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Element)) continue;
            backedList.addLocal(e);
        }
        return backedList;
    }

    public List elements(String string) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            Object e = list.get(i);
            if (!(e instanceof Element) || !string.equals((element = (Element)e).getName())) continue;
            backedList.addLocal(element);
        }
        return backedList;
    }

    public List elements(QName qName) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            Object e = list.get(i);
            if (!(e instanceof Element) || !qName.equals((element = (Element)e).getQName())) continue;
            backedList.addLocal(element);
        }
        return backedList;
    }

    public List elements(String string, Namespace namespace) {
        return this.elements(this.getDocumentFactory().createQName(string, namespace));
    }

    public Iterator elementIterator() {
        List list = this.elements();
        return list.iterator();
    }

    public Iterator elementIterator(String string) {
        List list = this.elements(string);
        return list.iterator();
    }

    public Iterator elementIterator(QName qName) {
        List list = this.elements(qName);
        return list.iterator();
    }

    public Iterator elementIterator(String string, Namespace namespace) {
        return this.elementIterator(this.getDocumentFactory().createQName(string, namespace));
    }

    public List attributes() {
        return new ContentListFacade(this, this.attributeList());
    }

    public Iterator attributeIterator() {
        return this.attributeList().iterator();
    }

    public Attribute attribute(int n) {
        return (Attribute)this.attributeList().get(n);
    }

    public int attributeCount() {
        return this.attributeList().size();
    }

    public Attribute attribute(String string) {
        List list = this.attributeList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)list.get(i);
            if (!string.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute attribute(QName qName) {
        List list = this.attributeList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)list.get(i);
            if (!qName.equals(attribute.getQName())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String string, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(string, namespace));
    }

    public void setAttributes(Attributes attributes, NamespaceStack namespaceStack, boolean bl) {
        int n = attributes.getLength();
        if (n > 0) {
            DocumentFactory documentFactory = this.getDocumentFactory();
            if (n == 1) {
                String string = attributes.getQName(0);
                if (bl || !string.startsWith("xmlns")) {
                    String string2 = attributes.getURI(0);
                    String string3 = attributes.getLocalName(0);
                    String string4 = attributes.getValue(0);
                    QName qName = namespaceStack.getAttributeQName(string2, string3, string);
                    this.add(documentFactory.createAttribute((Element)this, qName, string4));
                }
            } else {
                List list = this.attributeList(n);
                list.clear();
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getQName(i);
                    if (!bl && string.startsWith("xmlns")) continue;
                    String string5 = attributes.getURI(i);
                    String string6 = attributes.getLocalName(i);
                    String string7 = attributes.getValue(i);
                    QName qName = namespaceStack.getAttributeQName(string5, string6, string);
                    Attribute attribute = documentFactory.createAttribute((Element)this, qName, string7);
                    list.add(attribute);
                    this.childAdded(attribute);
                }
            }
        }
    }

    public String attributeValue(String string) {
        Attribute attribute = this.attribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public String attributeValue(QName qName) {
        Attribute attribute = this.attribute(qName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public String attributeValue(String string, String string2) {
        String string3 = this.attributeValue(string);
        return string3 != null ? string3 : string2;
    }

    public String attributeValue(QName qName, String string) {
        String string2 = this.attributeValue(qName);
        return string2 != null ? string2 : string;
    }

    public void setAttributeValue(String string, String string2) {
        this.addAttribute(string, string2);
    }

    public void setAttributeValue(QName qName, String string) {
        this.addAttribute(qName, string);
    }

    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String string = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, string);
        }
        if (attribute.getValue() == null) {
            Attribute attribute2 = this.attribute(attribute.getQName());
            if (attribute2 != null) {
                this.remove(attribute2);
            }
        } else {
            this.attributeList().add(attribute);
            this.childAdded(attribute);
        }
    }

    public boolean remove(Attribute attribute) {
        List list = this.attributeList();
        boolean bl = list.remove(attribute);
        if (bl) {
            this.childRemoved(attribute);
        } else {
            Attribute attribute2 = this.attribute(attribute.getQName());
            if (attribute2 != null) {
                list.remove(attribute2);
                bl = true;
            }
        }
        return bl;
    }

    public List processingInstructions() {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction)) continue;
            backedList.addLocal(e);
        }
        return backedList;
    }

    public List processingInstructions(String string) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ProcessingInstruction processingInstruction;
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            backedList.addLocal(processingInstruction);
        }
        return backedList;
    }

    public ProcessingInstruction processingInstruction(String string) {
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ProcessingInstruction processingInstruction;
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            return processingInstruction;
        }
        return null;
    }

    public boolean removeProcessingInstruction(String string) {
        List list = this.contentList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction;
            Object e = iterator.next();
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Node getXPathResult(int n) {
        Node node = this.node(n);
        if (node != null && !node.supportsParent()) {
            return node.asXPathResult(this);
        }
        return node;
    }

    public Element addAttribute(String string, String string2) {
        Attribute attribute = this.attribute(string);
        if (string2 != null) {
            if (attribute == null) {
                this.add(this.getDocumentFactory().createAttribute((Element)this, string, string2));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                this.add(this.getDocumentFactory().createAttribute((Element)this, string, string2));
            } else {
                attribute.setValue(string2);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    public Element addAttribute(QName qName, String string) {
        Attribute attribute = this.attribute(qName);
        if (string != null) {
            if (attribute == null) {
                this.add(this.getDocumentFactory().createAttribute((Element)this, qName, string));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                this.add(this.getDocumentFactory().createAttribute((Element)this, qName, string));
            } else {
                attribute.setValue(string);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    public Element addCDATA(String string) {
        CDATA cDATA = this.getDocumentFactory().createCDATA(string);
        this.addNewNode(cDATA);
        return this;
    }

    public Element addComment(String string) {
        Comment comment = this.getDocumentFactory().createComment(string);
        this.addNewNode(comment);
        return this;
    }

    public Element addElement(String string) {
        Element element;
        DocumentFactory documentFactory = this.getDocumentFactory();
        int n = string.indexOf(":");
        String string2 = "";
        String string3 = string;
        Namespace namespace = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            namespace = this.getNamespaceForPrefix(string2);
            if (namespace == null) {
                throw new IllegalAddException("No such namespace prefix: " + string2 + " is in scope on: " + this + " so cannot add element: " + string);
            }
        } else {
            namespace = this.getNamespaceForPrefix("");
        }
        if (namespace != null) {
            QName qName = documentFactory.createQName(string3, namespace);
            element = documentFactory.createElement(qName);
        } else {
            element = documentFactory.createElement(string);
        }
        this.addNewNode(element);
        return element;
    }

    public Element addEntity(String string, String string2) {
        Entity entity = this.getDocumentFactory().createEntity(string, string2);
        this.addNewNode(entity);
        return this;
    }

    public Element addNamespace(String string, String string2) {
        Namespace namespace = this.getDocumentFactory().createNamespace(string, string2);
        this.addNewNode(namespace);
        return this;
    }

    public Element addProcessingInstruction(String string, String string2) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, string2);
        this.addNewNode(processingInstruction);
        return this;
    }

    public Element addProcessingInstruction(String string, Map map) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, map);
        this.addNewNode(processingInstruction);
        return this;
    }

    public Element addText(String string) {
        Text text = this.getDocumentFactory().createText(string);
        this.addNewNode(text);
        return this;
    }

    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.add((Element)node);
                break;
            }
            case 2: {
                this.add((Attribute)node);
                break;
            }
            case 3: {
                this.add((Text)node);
                break;
            }
            case 4: {
                this.add((CDATA)node);
                break;
            }
            case 5: {
                this.add((Entity)node);
                break;
            }
            case 7: {
                this.add((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.add((Comment)node);
                break;
            }
            case 13: {
                this.add((Namespace)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.remove((Element)node);
            }
            case 2: {
                return this.remove((Attribute)node);
            }
            case 3: {
                return this.remove((Text)node);
            }
            case 4: {
                return this.remove((CDATA)node);
            }
            case 5: {
                return this.remove((Entity)node);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node);
            }
            case 8: {
                return this.remove((Comment)node);
            }
            case 13: {
                return this.remove((Namespace)node);
            }
        }
        return false;
    }

    public void add(CDATA cDATA) {
        this.addNode(cDATA);
    }

    public void add(Comment comment) {
        this.addNode(comment);
    }

    public void add(Element element) {
        this.addNode(element);
    }

    public void add(Entity entity) {
        this.addNode(entity);
    }

    public void add(Namespace namespace) {
        this.addNode(namespace);
    }

    public void add(ProcessingInstruction processingInstruction) {
        this.addNode(processingInstruction);
    }

    public void add(Text text) {
        this.addNode(text);
    }

    public boolean remove(CDATA cDATA) {
        return this.removeNode(cDATA);
    }

    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    public boolean remove(Entity entity) {
        return this.removeNode(entity);
    }

    public boolean remove(Namespace namespace) {
        return this.removeNode(namespace);
    }

    public boolean remove(ProcessingInstruction processingInstruction) {
        return this.removeNode(processingInstruction);
    }

    public boolean remove(Text text) {
        return this.removeNode(text);
    }

    public boolean hasMixedContent() {
        List list = this.contentList();
        if (list == null || list.isEmpty() || list.size() < 2) {
            return false;
        }
        Class<?> clazz = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz2 = e.getClass();
            if (clazz2 == clazz) continue;
            if (clazz != null) {
                return true;
            }
            clazz = clazz2;
        }
        return false;
    }

    public boolean isTextOnly() {
        List list = this.contentList();
        if (list == null || list.isEmpty()) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CharacterData || e instanceof String) continue;
            return false;
        }
        return true;
    }

    public void setText(String string) {
        List list = this.contentList();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        iterator.remove();
                    }
                }
            }
        }
        this.addText(string);
    }

    public String getStringValue() {
        List list = this.contentList();
        int n = list.size();
        if (n > 0) {
            if (n == 1) {
                return this.getContentAsStringValue(list.get(0));
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                String string = this.getContentAsStringValue(e);
                if (string.length() <= 0) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void normalize() {
        List list = this.contentList();
        Node node = null;
        int n = 0;
        while (n < list.size()) {
            Node node2;
            Node node3 = (Node)list.get(n);
            if (node3 instanceof Text) {
                node2 = (Text)node3;
                if (node != null) {
                    node.appendText(node2.getText());
                    this.remove((Text)node2);
                    continue;
                }
                String string = node2.getText();
                if (string == null || string.length() <= 0) {
                    this.remove((Text)node2);
                    continue;
                }
                node = node2;
                ++n;
                continue;
            }
            if (node3 instanceof Element) {
                node2 = (Element)node3;
                node2.normalize();
            }
            node = null;
            ++n;
        }
    }

    public String elementText(String string) {
        Element element = this.element(string);
        return element != null ? element.getText() : null;
    }

    public String elementText(QName qName) {
        Element element = this.element(qName);
        return element != null ? element.getText() : null;
    }

    public String elementTextTrim(String string) {
        Element element = this.element(string);
        return element != null ? element.getTextTrim() : null;
    }

    public String elementTextTrim(QName qName) {
        Element element = this.element(qName);
        return element != null ? element.getTextTrim() : null;
    }

    public void appendAttributes(Element element) {
        int n = element.attributeCount();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = element.attribute(i);
            if (attribute.supportsParent()) {
                this.addAttribute(attribute.getQName(), attribute.getValue());
                continue;
            }
            this.add(attribute);
        }
    }

    public Element createCopy() {
        Element element = this.createElement(this.getQName());
        element.appendAttributes(this);
        element.appendContent(this);
        return element;
    }

    public Element createCopy(String string) {
        Element element = this.createElement(string);
        element.appendAttributes(this);
        element.appendContent(this);
        return element;
    }

    public Element createCopy(QName qName) {
        Element element = this.createElement(qName);
        element.appendAttributes(this);
        element.appendContent(this);
        return element;
    }

    public QName getQName(String string) {
        Namespace namespace;
        String string2 = "";
        String string3 = string;
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if ((namespace = this.getNamespaceForPrefix(string2)) != null) {
            return this.getDocumentFactory().createQName(string3, namespace);
        }
        return this.getDocumentFactory().createQName(string3);
    }

    public Namespace getNamespaceForPrefix(String string) {
        Namespace namespace;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        Object object = this.contentList();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace2;
            Object e = object.get(i);
            if (!(e instanceof Namespace) || !string.equals((namespace2 = (Namespace)e).getPrefix())) continue;
            return namespace2;
        }
        object = this.getParent();
        if (object != null && (namespace = object.getNamespaceForPrefix(string)) != null) {
            return namespace;
        }
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    public Namespace getNamespaceForURI(String string) {
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace;
            Object e = list.get(i);
            if (!(e instanceof Namespace) || !string.equals((namespace = (Namespace)e).getURI())) continue;
            return namespace;
        }
        return null;
    }

    public List getNamespacesForURI(String string) {
        BackedList backedList = this.createResultList();
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Namespace) || !((Namespace)e).getURI().equals(string)) continue;
            backedList.addLocal(e);
        }
        return backedList;
    }

    public List declaredNamespaces() {
        BackedList backedList = this.createResultList();
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Namespace)) continue;
            backedList.addLocal(e);
        }
        return backedList;
    }

    public List additionalNamespaces() {
        List list = this.contentList();
        int n = list.size();
        BackedList backedList = this.createResultList();
        for (int i = 0; i < n; ++i) {
            Namespace namespace;
            Object e = list.get(i);
            if (!(e instanceof Namespace) || (namespace = (Namespace)e).equals(this.getNamespace())) continue;
            backedList.addLocal(namespace);
        }
        return backedList;
    }

    public List additionalNamespaces(String string) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace;
            Object e = list.get(i);
            if (!(e instanceof Namespace) || string.equals((namespace = (Namespace)e).getURI())) continue;
            backedList.addLocal(namespace);
        }
        return backedList;
    }

    public void ensureAttributesCapacity(int n) {
        List list;
        if (n > 1 && (list = this.attributeList()) instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)list;
            arrayList.ensureCapacity(n);
        }
    }

    protected Element createElement(String string) {
        return this.getDocumentFactory().createElement(string);
    }

    protected Element createElement(QName qName) {
        return this.getDocumentFactory().createElement(qName);
    }

    protected void addNode(Node node) {
        if (node.getParent() != null) {
            String string = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, string);
        }
        this.addNewNode(node);
    }

    protected void addNode(int n, Node node) {
        if (node.getParent() != null) {
            String string = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, string);
        }
        this.addNewNode(n, node);
    }

    protected void addNewNode(Node node) {
        this.contentList().add(node);
        this.childAdded(node);
    }

    protected void addNewNode(int n, Node node) {
        this.contentList().add(n, node);
        this.childAdded(node);
    }

    protected boolean removeNode(Node node) {
        boolean bl = this.contentList().remove(node);
        if (bl) {
            this.childRemoved(node);
        }
        return bl;
    }

    protected void childAdded(Node node) {
        if (node != null) {
            node.setParent(this);
        }
    }

    protected void childRemoved(Node node) {
        if (node != null) {
            node.setParent(null);
            node.setDocument(null);
        }
    }

    protected abstract List attributeList();

    protected abstract List attributeList(int var1);

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory;
        QName qName = this.getQName();
        if (qName != null && (documentFactory = qName.getDocumentFactory()) != null) {
            return documentFactory;
        }
        return DOCUMENT_FACTORY;
    }

    protected List createAttributeList() {
        return this.createAttributeList(5);
    }

    protected List createAttributeList(int n) {
        return new ArrayList(n);
    }

    protected Iterator createSingleIterator(Object object) {
        return new SingleIterator(object);
    }
}

