/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Pattern;

public class Rule
implements Comparable {
    private String mode;
    private int importPrecedence;
    private double priority;
    private int appearenceCount;
    private Pattern pattern;
    private Action action;

    public Rule() {
        this.priority = 0.5;
    }

    public Rule(Pattern pattern) {
        this.pattern = pattern;
        this.priority = pattern.getPriority();
    }

    public Rule(Pattern pattern, Action action) {
        this(pattern);
        this.action = action;
    }

    public Rule(Rule rule, Pattern pattern) {
        this.mode = rule.mode;
        this.importPrecedence = rule.importPrecedence;
        this.priority = rule.priority;
        this.appearenceCount = rule.appearenceCount;
        this.action = rule.action;
        this.pattern = pattern;
    }

    public boolean equals(Object object) {
        if (object instanceof Rule) {
            return this.compareTo((Rule)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.importPrecedence + this.appearenceCount;
    }

    public int compareTo(Object object) {
        if (object instanceof Rule) {
            return this.compareTo((Rule)object);
        }
        return this.getClass().getName().compareTo(object.getClass().getName());
    }

    public int compareTo(Rule rule) {
        int n = this.importPrecedence - rule.importPrecedence;
        if (n == 0 && (n = (int)Math.round(this.priority - rule.priority)) == 0) {
            n = this.appearenceCount - rule.appearenceCount;
        }
        return n;
    }

    public String toString() {
        return super.toString() + "[ pattern: " + this.getPattern() + " action: " + this.getAction() + " ]";
    }

    public final boolean matches(Node node) {
        return this.pattern.matches(node);
    }

    public Rule[] getUnionRules() {
        Pattern[] patternArray = this.pattern.getUnionPatterns();
        if (patternArray == null) {
            return null;
        }
        int n = patternArray.length;
        Rule[] ruleArray = new Rule[n];
        for (int i = 0; i < n; ++i) {
            ruleArray[i] = new Rule(this, patternArray[i]);
        }
        return ruleArray;
    }

    public final short getMatchType() {
        return this.pattern.getMatchType();
    }

    public final String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public int getImportPrecedence() {
        return this.importPrecedence;
    }

    public void setImportPrecedence(int n) {
        this.importPrecedence = n;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double d) {
        this.priority = d;
    }

    public int getAppearenceCount() {
        return this.appearenceCount;
    }

    public void setAppearenceCount(int n) {
        this.appearenceCount = n;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }
}

