/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.io.DispatchHandler;
import org.dom4j.xpp.ProxyXmlStartTag;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlPullParserFactory;
import org.gjt.xpp.XmlStartTag;

public class XPPReader {
    private DocumentFactory factory;
    private XmlPullParser xppParser;
    private XmlPullParserFactory xppFactory;
    private DispatchHandler dispatchHandler;

    public XPPReader() {
    }

    public XPPReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Document read(File file) throws DocumentException, IOException, XmlPullParserException {
        String string = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), string);
    }

    public Document read(URL uRL) throws DocumentException, IOException, XmlPullParserException {
        String string = uRL.toExternalForm();
        return this.read(this.createReader(uRL.openStream()), string);
    }

    public Document read(String string) throws DocumentException, IOException, XmlPullParserException {
        if (string.indexOf(58) >= 0) {
            return this.read(new URL(string));
        }
        return this.read(new File(string));
    }

    public Document read(InputStream inputStream) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(inputStream));
    }

    public Document read(Reader reader) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput(reader);
        return this.parseDocument();
    }

    public Document read(char[] cArray) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput(cArray);
        return this.parseDocument();
    }

    public Document read(InputStream inputStream, String string) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(inputStream), string);
    }

    public Document read(Reader reader, String string) throws DocumentException, IOException, XmlPullParserException {
        Document document = this.read(reader);
        document.setName(string);
        return document;
    }

    public XmlPullParser getXPPParser() throws XmlPullParserException {
        if (this.xppParser == null) {
            this.xppParser = this.getXPPFactory().newPullParser();
        }
        return this.xppParser;
    }

    public XmlPullParserFactory getXPPFactory() throws XmlPullParserException {
        if (this.xppFactory == null) {
            this.xppFactory = XmlPullParserFactory.newInstance();
        }
        return this.xppFactory;
    }

    public void setXPPFactory(XmlPullParserFactory xmlPullParserFactory) {
        this.xppFactory = xmlPullParserFactory;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    protected Document parseDocument() throws DocumentException, IOException, XmlPullParserException {
        byte by;
        Document document = this.getDocumentFactory().createDocument();
        Object object = null;
        XmlPullParser xmlPullParser = this.getXPPParser();
        xmlPullParser.setNamespaceAware(true);
        ProxyXmlStartTag proxyXmlStartTag = new ProxyXmlStartTag();
        XmlEndTag xmlEndTag = this.xppFactory.newEndTag();
        block6: while (true) {
            by = xmlPullParser.next();
            switch (by) {
                case 1: {
                    return document;
                }
                case 2: {
                    xmlPullParser.readStartTag((XmlStartTag)proxyXmlStartTag);
                    Object object2 = proxyXmlStartTag.getElement();
                    if (object != null) {
                        object.add((Element)object2);
                    } else {
                        document.add((Element)object2);
                    }
                    object = object2;
                    continue block6;
                }
                case 3: {
                    xmlPullParser.readEndTag(xmlEndTag);
                    if (object == null) continue block6;
                    object = object.getParent();
                    continue block6;
                }
                case 4: {
                    Object object2 = xmlPullParser.readContent();
                    if (object != null) {
                        object.addText((String)object2);
                        continue block6;
                    }
                    String string = "Cannot have text content outside of the root document";
                    throw new DocumentException(string);
                }
            }
            break;
        }
        throw new DocumentException("Error: unknown type: " + by);
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected Reader createReader(InputStream inputStream) throws IOException {
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

