/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.DispatchHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XPP3Reader {
    private DocumentFactory factory;
    private XmlPullParser xppParser;
    private XmlPullParserFactory xppFactory;
    private DispatchHandler dispatchHandler;

    public XPP3Reader() {
    }

    public XPP3Reader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Document read(File file) throws DocumentException, IOException, XmlPullParserException {
        String string = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), string);
    }

    public Document read(URL uRL) throws DocumentException, IOException, XmlPullParserException {
        String string = uRL.toExternalForm();
        return this.read(this.createReader(uRL.openStream()), string);
    }

    public Document read(String string) throws DocumentException, IOException, XmlPullParserException {
        if (string.indexOf(58) >= 0) {
            return this.read(new URL(string));
        }
        return this.read(new File(string));
    }

    public Document read(InputStream inputStream) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(inputStream));
    }

    public Document read(Reader reader) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput(reader);
        return this.parseDocument();
    }

    public Document read(char[] cArray) throws DocumentException, IOException, XmlPullParserException {
        this.getXPPParser().setInput((Reader)new CharArrayReader(cArray));
        return this.parseDocument();
    }

    public Document read(InputStream inputStream, String string) throws DocumentException, IOException, XmlPullParserException {
        return this.read(this.createReader(inputStream), string);
    }

    public Document read(Reader reader, String string) throws DocumentException, IOException, XmlPullParserException {
        Document document = this.read(reader);
        document.setName(string);
        return document;
    }

    public XmlPullParser getXPPParser() throws XmlPullParserException {
        if (this.xppParser == null) {
            this.xppParser = this.getXPPFactory().newPullParser();
        }
        return this.xppParser;
    }

    public XmlPullParserFactory getXPPFactory() throws XmlPullParserException {
        if (this.xppFactory == null) {
            this.xppFactory = XmlPullParserFactory.newInstance();
        }
        this.xppFactory.setNamespaceAware(true);
        return this.xppFactory;
    }

    public void setXPPFactory(XmlPullParserFactory xmlPullParserFactory) {
        this.xppFactory = xmlPullParserFactory;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    protected Document parseDocument() throws DocumentException, IOException, XmlPullParserException {
        DocumentFactory documentFactory = this.getDocumentFactory();
        Document document = documentFactory.createDocument();
        Node node = null;
        XmlPullParser xmlPullParser = this.getXPPParser();
        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        while (true) {
            int n = xmlPullParser.nextToken();
            switch (n) {
                case 8: {
                    Object object = xmlPullParser.getText();
                    int n2 = ((String)object).indexOf(" ");
                    if (n2 >= 0) {
                        String string = ((String)object).substring(0, n2);
                        String string2 = ((String)object).substring(n2 + 1);
                        document.addProcessingInstruction(string, string2);
                        break;
                    }
                    document.addProcessingInstruction((String)object, "");
                    break;
                }
                case 9: {
                    if (node != null) {
                        node.addComment(xmlPullParser.getText());
                        break;
                    }
                    document.addComment(xmlPullParser.getText());
                    break;
                }
                case 5: {
                    if (node != null) {
                        node.addCDATA(xmlPullParser.getText());
                        break;
                    }
                    Object object = "Cannot have text content outside of the root document";
                    throw new DocumentException((String)object);
                }
                case 6: {
                    break;
                }
                case 1: {
                    return document;
                }
                case 2: {
                    int n3;
                    Object object = xmlPullParser.getPrefix() == null ? documentFactory.createQName(xmlPullParser.getName(), xmlPullParser.getNamespace()) : documentFactory.createQName(xmlPullParser.getName(), xmlPullParser.getPrefix(), xmlPullParser.getNamespace());
                    Element element = documentFactory.createElement((QName)object);
                    int n4 = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1);
                    int n5 = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth());
                    for (n3 = n4; n3 < n5; ++n3) {
                        if (xmlPullParser.getNamespacePrefix(n3) == null) continue;
                        element.addNamespace(xmlPullParser.getNamespacePrefix(n3), xmlPullParser.getNamespaceUri(n3));
                    }
                    for (n3 = 0; n3 < xmlPullParser.getAttributeCount(); ++n3) {
                        QName qName = xmlPullParser.getAttributePrefix(n3) == null ? documentFactory.createQName(xmlPullParser.getAttributeName(n3)) : documentFactory.createQName(xmlPullParser.getAttributeName(n3), xmlPullParser.getAttributePrefix(n3), xmlPullParser.getAttributeNamespace(n3));
                        element.addAttribute(qName, xmlPullParser.getAttributeValue(n3));
                    }
                    if (node != null) {
                        node.add(element);
                    } else {
                        document.add(element);
                    }
                    node = element;
                    break;
                }
                case 3: {
                    if (node == null) break;
                    node = node.getParent();
                    break;
                }
                case 4: {
                    Object object = xmlPullParser.getText();
                    if (node != null) {
                        node.addText((String)object);
                        break;
                    }
                    String string = "Cannot have text content outside of the root document";
                    throw new DocumentException(string);
                }
            }
        }
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected Reader createReader(InputStream inputStream) throws IOException {
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

