/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.dom4j.Attribute;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;

public class STAXEventReader {
    private DocumentFactory factory;
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public STAXEventReader() {
        this.factory = DocumentFactory.getInstance();
    }

    public STAXEventReader(DocumentFactory documentFactory) {
        this.factory = documentFactory != null ? documentFactory : DocumentFactory.getInstance();
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory != null ? documentFactory : DocumentFactory.getInstance();
    }

    public Document readDocument(InputStream inputStream) throws XMLStreamException {
        return this.readDocument(inputStream, null);
    }

    public Document readDocument(Reader reader) throws XMLStreamException {
        return this.readDocument(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readDocument(InputStream inputStream, String string) throws XMLStreamException {
        XMLEventReader xMLEventReader = this.inputFactory.createXMLEventReader(string, inputStream);
        try {
            Document document = this.readDocument(xMLEventReader);
            return document;
        }
        finally {
            xMLEventReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readDocument(Reader reader, String string) throws XMLStreamException {
        XMLEventReader xMLEventReader = this.inputFactory.createXMLEventReader(string, reader);
        try {
            Document document = this.readDocument(xMLEventReader);
            return document;
        }
        finally {
            xMLEventReader.close();
        }
    }

    public Node readNode(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement()) {
            return this.readElement(xMLEventReader);
        }
        if (xMLEvent.isCharacters()) {
            return this.readCharacters(xMLEventReader);
        }
        if (xMLEvent.isStartDocument()) {
            return this.readDocument(xMLEventReader);
        }
        if (xMLEvent.isProcessingInstruction()) {
            return this.readProcessingInstruction(xMLEventReader);
        }
        if (xMLEvent.isEntityReference()) {
            return this.readEntityReference(xMLEventReader);
        }
        if (xMLEvent.isAttribute()) {
            return this.readAttribute(xMLEventReader);
        }
        if (xMLEvent.isNamespace()) {
            return this.readNamespace(xMLEventReader);
        }
        throw new XMLStreamException("Unsupported event: " + xMLEvent);
    }

    public Document readDocument(XMLEventReader xMLEventReader) throws XMLStreamException {
        Document document = null;
        block4: while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.peek();
            int n = xMLEvent.getEventType();
            switch (n) {
                case 7: {
                    StartDocument startDocument = (StartDocument)xMLEventReader.nextEvent();
                    if (document == null) {
                        if (startDocument.encodingSet()) {
                            object = startDocument.getCharacterEncodingScheme();
                            document = this.factory.createDocument((String)object);
                            continue block4;
                        }
                        document = this.factory.createDocument();
                        continue block4;
                    }
                    object = "Unexpected StartDocument event";
                    throw new XMLStreamException((String)object, startDocument.getLocation());
                }
                case 4: 
                case 6: 
                case 8: {
                    xMLEventReader.nextEvent();
                    continue block4;
                }
            }
            if (document == null) {
                document = this.factory.createDocument();
            }
            object = this.readNode(xMLEventReader);
            document.add((Node)object);
        }
        return document;
    }

    public Element readElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement()) {
            StartElement startElement = xMLEventReader.nextEvent().asStartElement();
            Element element = this.createElement(startElement);
            while (true) {
                Object object;
                Object object2;
                if (!xMLEventReader.hasNext()) {
                    object2 = "Unexpected end of stream while reading element content";
                    throw new XMLStreamException((String)object2);
                }
                object2 = xMLEventReader.peek();
                if (object2.isEndElement()) {
                    object = xMLEventReader.nextEvent().asEndElement();
                    if (object.getName().equals(startElement.getName())) break;
                    throw new XMLStreamException("Expected " + startElement.getName() + " end-tag, but found" + object.getName());
                }
                object = this.readNode(xMLEventReader);
                element.add((Node)object);
            }
            return element;
        }
        throw new XMLStreamException("Expected Element event, found: " + xMLEvent);
    }

    public Attribute readAttribute(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isAttribute()) {
            javax.xml.stream.events.Attribute attribute = (javax.xml.stream.events.Attribute)xMLEventReader.nextEvent();
            return this.createAttribute(null, attribute);
        }
        throw new XMLStreamException("Expected Attribute event, found: " + xMLEvent);
    }

    public Namespace readNamespace(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isNamespace()) {
            javax.xml.stream.events.Namespace namespace = (javax.xml.stream.events.Namespace)xMLEventReader.nextEvent();
            return this.createNamespace(namespace);
        }
        throw new XMLStreamException("Expected Namespace event, found: " + xMLEvent);
    }

    public CharacterData readCharacters(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isCharacters()) {
            Characters characters = xMLEventReader.nextEvent().asCharacters();
            return this.createCharacterData(characters);
        }
        throw new XMLStreamException("Expected Characters event, found: " + xMLEvent);
    }

    public Comment readComment(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent instanceof javax.xml.stream.events.Comment) {
            return this.createComment((javax.xml.stream.events.Comment)xMLEventReader.nextEvent());
        }
        throw new XMLStreamException("Expected Comment event, found: " + xMLEvent);
    }

    public Entity readEntityReference(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isEntityReference()) {
            EntityReference entityReference = (EntityReference)xMLEventReader.nextEvent();
            return this.createEntity(entityReference);
        }
        throw new XMLStreamException("Expected EntityRef event, found: " + xMLEvent);
    }

    public ProcessingInstruction readProcessingInstruction(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isProcessingInstruction()) {
            javax.xml.stream.events.ProcessingInstruction processingInstruction = (javax.xml.stream.events.ProcessingInstruction)xMLEventReader.nextEvent();
            return this.createProcessingInstruction(processingInstruction);
        }
        throw new XMLStreamException("Expected PI event, found: " + xMLEvent);
    }

    public Element createElement(StartElement startElement) {
        javax.xml.stream.events.Attribute attribute;
        javax.xml.namespace.QName qName = startElement.getName();
        QName qName2 = this.createQName(qName);
        Element element = this.factory.createElement(qName2);
        Iterator<javax.xml.stream.events.Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            attribute = iterator.next();
            element.addAttribute(this.createQName(attribute.getName()), attribute.getValue());
        }
        iterator = startElement.getNamespaces();
        while (iterator.hasNext()) {
            attribute = (javax.xml.stream.events.Namespace)iterator.next();
            element.addNamespace(attribute.getPrefix(), attribute.getNamespaceURI());
        }
        return element;
    }

    public Attribute createAttribute(Element element, javax.xml.stream.events.Attribute attribute) {
        return this.factory.createAttribute(element, this.createQName(attribute.getName()), attribute.getValue());
    }

    public Namespace createNamespace(javax.xml.stream.events.Namespace namespace) {
        return this.factory.createNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
    }

    public CharacterData createCharacterData(Characters characters) {
        String string = characters.getData();
        if (characters.isCData()) {
            return this.factory.createCDATA(string);
        }
        return this.factory.createText(string);
    }

    public Comment createComment(javax.xml.stream.events.Comment comment) {
        return this.factory.createComment(comment.getText());
    }

    public Entity createEntity(EntityReference entityReference) {
        return this.factory.createEntity(entityReference.getName(), entityReference.getDeclaration().getReplacementText());
    }

    public ProcessingInstruction createProcessingInstruction(javax.xml.stream.events.ProcessingInstruction processingInstruction) {
        return this.factory.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    public QName createQName(javax.xml.namespace.QName qName) {
        return this.factory.createQName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }
}

