/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.DocumentInputSource;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXWriter
implements XMLReader {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    protected static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private AttributesImpl attributes = new AttributesImpl();
    private Map features = new HashMap();
    private Map properties = new HashMap();
    private boolean declareNamespaceAttributes;

    public SAXWriter() {
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.FALSE);
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.TRUE);
    }

    public SAXWriter(ContentHandler contentHandler) {
        this();
        this.contentHandler = contentHandler;
    }

    public SAXWriter(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public SAXWriter(ContentHandler contentHandler, LexicalHandler lexicalHandler, EntityResolver entityResolver) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.entityResolver = entityResolver;
    }

    public void write(Node node) throws SAXException {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                this.write((Element)node);
                break;
            }
            case 2: {
                this.write((Attribute)node);
                break;
            }
            case 3: {
                this.write(node.getText());
                break;
            }
            case 4: {
                this.write((CDATA)node);
                break;
            }
            case 5: {
                this.write((Entity)node);
                break;
            }
            case 7: {
                this.write((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.write((Comment)node);
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.write((DocumentType)node);
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new SAXException("Invalid node type: " + node);
            }
        }
    }

    public void write(Document document) throws SAXException {
        if (document != null) {
            this.checkForNullHandlers();
            this.documentLocator(document);
            this.startDocument();
            this.entityResolver(document);
            this.dtdHandler(document);
            this.writeContent(document, new NamespaceStack());
            this.endDocument();
        }
    }

    public void write(Element element) throws SAXException {
        this.write(element, new NamespaceStack());
    }

    public void writeOpen(Element element) throws SAXException {
        this.startElement(element, null);
    }

    public void writeClose(Element element) throws SAXException {
        this.endElement(element);
    }

    public void write(String string) throws SAXException {
        if (string != null) {
            char[] cArray = string.toCharArray();
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
    }

    public void write(CDATA cDATA) throws SAXException {
        String string = cDATA.getText();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
            this.write(string);
            this.lexicalHandler.endCDATA();
        } else {
            this.write(string);
        }
    }

    public void write(Comment comment) throws SAXException {
        if (this.lexicalHandler != null) {
            String string = comment.getText();
            char[] cArray = string.toCharArray();
            this.lexicalHandler.comment(cArray, 0, cArray.length);
        }
    }

    public void write(Entity entity) throws SAXException {
        String string = entity.getText();
        if (this.lexicalHandler != null) {
            String string2 = entity.getName();
            this.lexicalHandler.startEntity(string2);
            this.write(string);
            this.lexicalHandler.endEntity(string2);
        } else {
            this.write(string);
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws SAXException {
        String string = processingInstruction.getTarget();
        String string2 = processingInstruction.getText();
        this.contentHandler.processingInstruction(string, string2);
    }

    public boolean isDeclareNamespaceAttributes() {
        return this.declareNamespaceAttributes;
    }

    public void setDeclareNamespaceAttributes(boolean bl) {
        this.declareNamespaceAttributes = bl;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.setContentHandler(xMLReader.getContentHandler());
        this.setDTDHandler(xMLReader.getDTDHandler());
        this.setEntityResolver(xMLReader.getEntityResolver());
        this.setErrorHandler(xMLReader.getErrorHandler());
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = (Boolean)this.features.get(string);
        return bl != null && bl != false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NAMESPACE_PREFIXES.equals(string)) {
            this.setDeclareNamespaceAttributes(bl);
        } else if (FEATURE_NAMESPACE_PREFIXES.equals(string) && !bl) {
            String string2 = "Namespace feature is always supported in dom4j";
            throw new SAXNotSupportedException(string2);
        }
        this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setProperty(String string, Object object) {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(string)) continue;
            this.setLexicalHandler((LexicalHandler)object);
            return;
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(string)) continue;
            return this.getLexicalHandler();
        }
        return this.properties.get(string);
    }

    public void parse(String string) throws SAXNotSupportedException {
        throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
    }

    public void parse(InputSource inputSource) throws SAXException {
        if (!(inputSource instanceof DocumentInputSource)) {
            throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
        }
        DocumentInputSource documentInputSource = (DocumentInputSource)inputSource;
        Document document = documentInputSource.getDocument();
        this.write(document);
    }

    protected void writeContent(Branch branch, NamespaceStack namespaceStack) throws SAXException {
        Iterator iterator = branch.nodeIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                this.write((Element)e, namespaceStack);
                continue;
            }
            if (e instanceof CharacterData) {
                if (e instanceof Text) {
                    Text text = (Text)e;
                    this.write(text.getText());
                    continue;
                }
                if (e instanceof CDATA) {
                    this.write((CDATA)e);
                    continue;
                }
                if (e instanceof Comment) {
                    this.write((Comment)e);
                    continue;
                }
                throw new SAXException("Invalid Node in DOM4J content: " + e + " of type: " + e.getClass());
            }
            if (e instanceof String) {
                this.write((String)e);
                continue;
            }
            if (e instanceof Entity) {
                this.write((Entity)e);
                continue;
            }
            if (e instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)e);
                continue;
            }
            if (e instanceof Namespace) {
                this.write((Namespace)e);
                continue;
            }
            throw new SAXException("Invalid Node in DOM4J content: " + e);
        }
    }

    protected void documentLocator(Document document) throws SAXException {
        LocatorImpl locatorImpl = new LocatorImpl();
        String string = null;
        String string2 = null;
        DocumentType documentType = document.getDocType();
        if (documentType != null) {
            string = documentType.getPublicID();
            string2 = documentType.getSystemID();
        }
        if (string != null) {
            locatorImpl.setPublicId(string);
        }
        if (string2 != null) {
            locatorImpl.setSystemId(string2);
        }
        locatorImpl.setLineNumber(-1);
        locatorImpl.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(locatorImpl);
    }

    protected void entityResolver(Document document) throws SAXException {
        DocumentType documentType;
        if (this.entityResolver != null && (documentType = document.getDocType()) != null) {
            String string = documentType.getPublicID();
            String string2 = documentType.getSystemID();
            if (string != null || string2 != null) {
                try {
                    this.entityResolver.resolveEntity(string, string2);
                }
                catch (IOException iOException) {
                    throw new SAXException("Could not resolve publicID: " + string + " systemID: " + string2, iOException);
                }
            }
        }
    }

    protected void dtdHandler(Document document) throws SAXException {
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    protected void write(Element element, NamespaceStack namespaceStack) throws SAXException {
        int n = namespaceStack.size();
        AttributesImpl attributesImpl = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, attributesImpl);
        this.writeContent(element, namespaceStack);
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, n);
    }

    protected AttributesImpl startPrefixMapping(Element element, NamespaceStack namespaceStack) throws SAXException {
        AttributesImpl attributesImpl = null;
        Namespace namespace = element.getNamespace();
        if (namespace != null && !this.isIgnoreableNamespace(namespace, namespaceStack)) {
            namespaceStack.push(namespace);
            this.contentHandler.startPrefixMapping(namespace.getPrefix(), namespace.getURI());
            attributesImpl = this.addNamespaceAttribute(attributesImpl, namespace);
        }
        List list = element.declaredNamespaces();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace2 = (Namespace)list.get(i);
            if (this.isIgnoreableNamespace(namespace2, namespaceStack)) continue;
            namespaceStack.push(namespace2);
            this.contentHandler.startPrefixMapping(namespace2.getPrefix(), namespace2.getURI());
            attributesImpl = this.addNamespaceAttribute(attributesImpl, namespace2);
        }
        return attributesImpl;
    }

    protected void endPrefixMapping(NamespaceStack namespaceStack, int n) throws SAXException {
        while (namespaceStack.size() > n) {
            Namespace namespace = namespaceStack.pop();
            if (namespace == null) continue;
            this.contentHandler.endPrefixMapping(namespace.getPrefix());
        }
    }

    protected void startElement(Element element, AttributesImpl attributesImpl) throws SAXException {
        this.contentHandler.startElement(element.getNamespaceURI(), element.getName(), element.getQualifiedName(), this.createAttributes(element, attributesImpl));
    }

    protected void endElement(Element element) throws SAXException {
        this.contentHandler.endElement(element.getNamespaceURI(), element.getName(), element.getQualifiedName());
    }

    protected Attributes createAttributes(Element element, Attributes attributes) throws SAXException {
        this.attributes.clear();
        if (attributes != null) {
            this.attributes.setAttributes(attributes);
        }
        Iterator iterator = element.attributeIterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.attributes.addAttribute(attribute.getNamespaceURI(), attribute.getName(), attribute.getQualifiedName(), "CDATA", attribute.getValue());
        }
        return this.attributes;
    }

    protected AttributesImpl addNamespaceAttribute(AttributesImpl attributesImpl, Namespace namespace) {
        if (this.declareNamespaceAttributes) {
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            String string = namespace.getPrefix();
            String string2 = "xmlns";
            if (string != null && string.length() > 0) {
                string2 = "xmlns:" + string;
            }
            String string3 = "";
            String string4 = string;
            String string5 = "CDATA";
            String string6 = namespace.getURI();
            attributesImpl.addAttribute(string3, string4, string2, string5, string6);
        }
        return attributesImpl;
    }

    protected boolean isIgnoreableNamespace(Namespace namespace, NamespaceStack namespaceStack) {
        if (namespace.equals(Namespace.NO_NAMESPACE) || namespace.equals(Namespace.XML_NAMESPACE)) {
            return true;
        }
        String string = namespace.getURI();
        if (string == null || string.length() <= 0) {
            return true;
        }
        return namespaceStack.contains(namespace);
    }

    protected void checkForNullHandlers() {
    }
}

