/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.dtd.ExternalEntityDecl;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.ElementStack;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXContentHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private DocumentFactory documentFactory;
    private Document document;
    private ElementStack elementStack;
    private NamespaceStack namespaceStack;
    private ElementHandler elementHandler;
    private Locator locator;
    private String entity;
    private boolean insideDTDSection;
    private boolean insideCDATASection;
    private StringBuffer cdataText;
    private Map availableNamespaceMap = new HashMap();
    private List declaredNamespaceList = new ArrayList();
    private List internalDTDDeclarations;
    private List externalDTDDeclarations;
    private int declaredNamespaceIndex;
    private EntityResolver entityResolver;
    private InputSource inputSource;
    private Element currentElement;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private int entityLevel;
    private boolean internalDTDsubset = false;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private boolean ignoreComments = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public SAXContentHandler() {
        this(DocumentFactory.getInstance());
    }

    public SAXContentHandler(DocumentFactory documentFactory) {
        this(documentFactory, null);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
        this(documentFactory, elementHandler, null);
        this.elementStack = this.createElementStack();
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler, ElementStack elementStack) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.elementStack = elementStack;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.currentElement != null) {
            this.currentElement.addProcessingInstruction(string, string2);
        } else {
            this.getDocument().addProcessingInstruction(string, string2);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.namespaceStack.push(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.namespaceStack.pop(string);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    public void startDocument() throws SAXException {
        this.document = null;
        this.currentElement = null;
        this.elementStack.clear();
        if (this.elementHandler != null && this.elementHandler instanceof DispatchHandler) {
            this.elementStack.setDispatchHandler((DispatchHandler)this.elementHandler);
        }
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    public void endDocument() throws SAXException {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        QName qName = this.namespaceStack.getQName(string, string2, string3);
        Branch branch = this.currentElement;
        if (branch == null) {
            branch = this.getDocument();
        }
        Element element = branch.addElement(qName);
        this.addDeclaredNamespaces(element);
        this.addAttributes(element, attributes);
        this.elementStack.pushElement(element);
        this.currentElement = element;
        this.entity = null;
        if (this.elementHandler != null) {
            this.elementHandler.onStart(this.elementStack);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.elementHandler != null && this.currentElement != null) {
            this.elementHandler.onEnd(this.elementStack);
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.entity != null) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addEntity(this.entity, new String(cArray, n, n2));
                this.entity = null;
            } else if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.cdataText.append(new String(cArray, n, n2));
            } else if (this.mergeAdjacentText) {
                this.textBuffer.append(cArray, n, n2);
                this.textInTextBuffer = true;
            } else {
                this.currentElement.addText(new String(cArray, n, n2));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.getDocument().addDocType(string, string2, string3);
        this.insideDTDSection = true;
        this.internalDTDsubset = true;
    }

    public void endDTD() throws SAXException {
        this.insideDTDSection = false;
        DocumentType documentType = this.getDocument().getDocType();
        if (documentType != null) {
            if (this.internalDTDDeclarations != null) {
                documentType.setInternalDeclarations(this.internalDTDDeclarations);
            }
            if (this.externalDTDDeclarations != null) {
                documentType.setExternalDeclarations(this.externalDTDDeclarations);
            }
        }
        this.internalDTDDeclarations = null;
        this.externalDTDDeclarations = null;
    }

    public void startEntity(String string) throws SAXException {
        ++this.entityLevel;
        this.entity = null;
        if (!this.insideDTDSection && !this.isIgnorableEntity(string)) {
            this.entity = string;
        }
        this.internalDTDsubset = false;
    }

    public void endEntity(String string) throws SAXException {
        --this.entityLevel;
        this.entity = null;
        if (this.entityLevel == 0) {
            this.internalDTDsubset = true;
        }
    }

    public void startCDATA() throws SAXException {
        this.insideCDATASection = true;
        this.cdataText = new StringBuffer();
    }

    public void endCDATA() throws SAXException {
        this.insideCDATASection = false;
        this.currentElement.addCDATA(this.cdataText.toString());
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.ignoreComments) {
            if (this.mergeAdjacentText && this.textInTextBuffer) {
                this.completeCurrentTextNode();
            }
            String string = new String(cArray, n, n2);
            if (!this.insideDTDSection && string.length() > 0) {
                if (this.currentElement != null) {
                    this.currentElement.addComment(string);
                } else {
                    this.getDocument().addComment(string);
                }
            }
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ElementDecl(string, string2));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ElementDecl(string, string2));
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new InternalEntityDecl(string, string2));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new InternalEntityDecl(string, string2));
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        ExternalEntityDecl externalEntityDecl = new ExternalEntityDecl(string, string2, string3);
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(externalEntityDecl);
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(externalEntityDecl);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public ElementStack getElementStack() {
        return this.elementStack;
    }

    public void setElementStack(ElementStack elementStack) {
        this.elementStack = elementStack;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean bl) {
        this.includeInternalDTDDeclarations = bl;
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public void setIncludeExternalDTDDeclarations(boolean bl) {
        this.includeExternalDTDDeclarations = bl;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    protected void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean bl = true;
            int n = this.textBuffer.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(this.textBuffer.charAt(i))) continue;
                bl = false;
                break;
            }
            if (!bl) {
                this.currentElement.addText(this.textBuffer.toString());
            }
        } else {
            this.currentElement.addText(this.textBuffer.toString());
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected Document createDocument() {
        String string = this.getEncoding();
        Document document = this.documentFactory.createDocument(string);
        document.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            document.setName(this.inputSource.getSystemId());
        }
        return document;
    }

    private String getEncoding() {
        if (this.locator == null) {
            return null;
        }
        try {
            Method method = this.locator.getClass().getMethod("getEncoding", new Class[0]);
            if (method != null) {
                return (String)method.invoke((Object)this.locator, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean isIgnorableEntity(String string) {
        return "amp".equals(string) || "apos".equals(string) || "gt".equals(string) || "lt".equals(string) || "quot".equals(string);
    }

    protected void addDeclaredNamespaces(Element element) {
        Namespace namespace = element.getNamespace();
        int n = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < n) {
            Namespace namespace2 = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            element.add(namespace2);
            ++this.declaredNamespaceIndex;
        }
    }

    protected void addAttributes(Element element, Attributes attributes) {
        boolean bl = false;
        if (element instanceof AbstractElement) {
            AbstractElement abstractElement = (AbstractElement)element;
            abstractElement.setAttributes(attributes, this.namespaceStack, bl);
        } else {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                if (!bl && string.startsWith("xmlns")) continue;
                String string2 = attributes.getURI(i);
                String string3 = attributes.getLocalName(i);
                String string4 = attributes.getValue(i);
                QName qName = this.namespaceStack.getAttributeQName(string2, string3, string);
                element.addAttribute(qName, string4);
            }
        }
    }

    protected void addDTDDeclaration(Object object) {
        if (this.internalDTDDeclarations == null) {
            this.internalDTDDeclarations = new ArrayList();
        }
        this.internalDTDDeclarations.add(object);
    }

    protected void addExternalDTDDeclaration(Object object) {
        if (this.externalDTDDeclarations == null) {
            this.externalDTDDeclarations = new ArrayList();
        }
        this.externalDTDDeclarations.add(object);
    }

    protected ElementStack createElementStack() {
        return new ElementStack();
    }
}

