/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultNamespace;
import org.dom4j.tree.NamespaceCache;

public class Namespace
extends AbstractNode {
    protected static final NamespaceCache CACHE = new NamespaceCache();
    public static final Namespace XML_NAMESPACE = CACHE.get("xml", "http://www.w3.org/XML/1998/namespace");
    public static final Namespace NO_NAMESPACE = CACHE.get("", "");
    private String prefix;
    private String uri;
    private int hashCode;

    public Namespace(String string, String string2) {
        this.prefix = string != null ? string : "";
        this.uri = string2 != null ? string2 : "";
    }

    public static Namespace get(String string, String string2) {
        return CACHE.get(string, string2);
    }

    public static Namespace get(String string) {
        return CACHE.get(string);
    }

    public short getNodeType() {
        return 13;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.createHashCode();
        }
        return this.hashCode;
    }

    protected int createHashCode() {
        int n = this.uri.hashCode() ^ this.prefix.hashCode();
        if (n == 0) {
            n = 47806;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            if (this.hashCode() == namespace.hashCode()) {
                return this.uri.equals(namespace.getURI()) && this.prefix.equals(namespace.getPrefix());
            }
        }
        return false;
    }

    public String getText() {
        return this.uri;
    }

    public String getStringValue() {
        return this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public String getXPathNameStep() {
        if (this.prefix != null && !"".equals(this.prefix)) {
            return "namespace::" + this.prefix;
        }
        return "namespace::*[name()='']";
    }

    public String getPath(Element element) {
        StringBuffer stringBuffer = new StringBuffer(10);
        Element element2 = this.getParent();
        if (element2 != null && element2 != element) {
            stringBuffer.append(element2.getPath(element));
            stringBuffer.append('/');
        }
        stringBuffer.append(this.getXPathNameStep());
        return stringBuffer.toString();
    }

    public String getUniquePath(Element element) {
        StringBuffer stringBuffer = new StringBuffer(10);
        Element element2 = this.getParent();
        if (element2 != null && element2 != element) {
            stringBuffer.append(element2.getUniquePath(element));
            stringBuffer.append('/');
        }
        stringBuffer.append(this.getXPathNameStep());
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + " [Namespace: prefix " + this.getPrefix() + " mapped to URI \"" + this.getURI() + "\"]";
    }

    public String asXML() {
        StringBuffer stringBuffer = new StringBuffer(10);
        String string = this.getPrefix();
        if (string != null && string.length() > 0) {
            stringBuffer.append("xmlns:");
            stringBuffer.append(string);
            stringBuffer.append("=\"");
        } else {
            stringBuffer.append("xmlns=\"");
        }
        stringBuffer.append(this.getURI());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    protected Node createXPathResult(Element element) {
        return new DefaultNamespace(element, this.getPrefix(), this.getURI());
    }
}

