/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.jackson.jsh;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import com.github.skjolber.jackson.jsh.DefaultSyntaxHighlighter;
import com.github.skjolber.jackson.jsh.JsonStreamContextListener;
import com.github.skjolber.jackson.jsh.SyntaxHighlighter;
import com.github.skjolber.jackson.jsh.SyntaxHighlighterIndenter;
import com.github.skjolber.jackson.jsh.SyntaxHighlightingPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class SyntaxHighlightingJsonGenerator
extends JsonGeneratorDelegate {
    protected SyntaxHighlightingPrettyPrinter prettyPrinter;
    protected SyntaxHighlighterIndenter objectIndenter;
    protected SyntaxHighlighterIndenter arrayIndenter;
    protected SyntaxHighlighter syntaxHighlighter;

    public SyntaxHighlightingJsonGenerator(JsonGenerator d) {
        this(d, true);
    }

    public SyntaxHighlightingJsonGenerator(JsonGenerator d, boolean prettyPrint) {
        this(d, new DefaultSyntaxHighlighter(), null, prettyPrint);
    }

    public SyntaxHighlightingJsonGenerator(JsonGenerator d, SyntaxHighlighter syntaxHighlighter, boolean prettyPrint) {
        this(d, syntaxHighlighter, null, prettyPrint);
    }

    public SyntaxHighlightingJsonGenerator(JsonGenerator d, SyntaxHighlighter syntaxHighlighter, JsonStreamContextListener listener, boolean prettyPrint) {
        super(d, false);
        this.syntaxHighlighter = syntaxHighlighter;
        this.objectIndenter = new SyntaxHighlighterIndenter(syntaxHighlighter, (DefaultPrettyPrinter.Indenter)(prettyPrint ? new DefaultIndenter() : new DefaultPrettyPrinter.FixedSpaceIndenter()));
        this.arrayIndenter = new SyntaxHighlighterIndenter(syntaxHighlighter, (DefaultPrettyPrinter.Indenter)new DefaultPrettyPrinter.FixedSpaceIndenter());
        this.prettyPrinter = new SyntaxHighlightingPrettyPrinter(syntaxHighlighter, this.objectIndenter, this.arrayIndenter, listener);
        this.setPrettyPrinter((PrettyPrinter)this.prettyPrinter);
    }

    public void writeFieldName(String value) throws IOException {
        this.prettyPrinter.setCommaColor(this.syntaxHighlighter.forComma());
        this.objectIndenter.setValueColor(this.syntaxHighlighter.forFieldName(value));
        super.writeFieldName(value);
        this.objectIndenter.clearValueColor();
        this.prettyPrinter.cleanCommaColor();
    }

    public void writeFieldName(SerializableString name) throws IOException {
        this.prettyPrinter.setCommaColor(this.syntaxHighlighter.forComma());
        this.objectIndenter.setValueColor(this.syntaxHighlighter.forFieldName(name.getValue()));
        super.writeFieldName(name);
        this.objectIndenter.clearValueColor();
        this.prettyPrinter.cleanCommaColor();
    }

    public void writeFieldId(long id) throws IOException {
        this.prettyPrinter.setCommaColor(this.syntaxHighlighter.forComma());
        this.objectIndenter.setValueColor(this.syntaxHighlighter.forFieldName(Long.toString(id)));
        super.writeFieldId(id);
        this.objectIndenter.clearValueColor();
        this.prettyPrinter.cleanCommaColor();
    }

    public void writeArray(int[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray();
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.arrayIndenter.setValueColor(this.syntaxHighlighter.forNumber(array[i]));
            super.writeNumber(array[i]);
        }
        this.writeEndArray();
        this.arrayIndenter.clearValueColor();
    }

    public void writeArray(long[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray();
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.arrayIndenter.setValueColor(this.syntaxHighlighter.forNumber(array[i]));
            super.writeNumber(array[i]);
        }
        this.writeEndArray();
        this.arrayIndenter.clearValueColor();
    }

    public void writeArray(double[] array, int offset, int length) throws IOException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray();
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.arrayIndenter.setValueColor(this.syntaxHighlighter.forNumber(array[i]));
            super.writeNumber(array[i]);
        }
        this.writeEndArray();
        this.arrayIndenter.clearValueColor();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forBinary());
        super.writeBinary(b64variant, data, offset, len);
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forBinary());
        return super.writeBinary(b64variant, data, dataLength);
    }

    public void writeNumber(short v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(int v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(long v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(double v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(float v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(v));
        super.writeNumber(v);
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNumber(encodedValue));
        super.writeNumber(encodedValue);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forBoolean(value));
        super.writeBoolean(value);
    }

    public void writeNull() throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forNull());
        super.writeNull();
    }

    public void writeString(String value) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forString(value));
        super.writeString(value);
    }

    public void writeString(Reader reader, int len) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forString(null));
        this.delegate.writeString(reader, len);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forString(new String(text, offset, len)));
        this.delegate.writeString(text, offset, len);
    }

    public void writeString(SerializableString text) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forString(text.getValue()));
        this.delegate.writeString(text);
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.prettyPrinter.setValueColor(this.syntaxHighlighter.forString(new String(text, offset, length, StandardCharsets.UTF_8)));
        this.delegate.writeUTF8String(text, offset, length);
    }

    public void close() throws IOException {
        this.flush();
        this.delegate.writeRaw("\u001b[0m");
        super.close();
    }
}

