> * 原文地址：[Unpopular Opinion: It’s harder than ever to be a good software engineer](https://dev.to/mjuraj/unpopular-opinion-its-harder-than-ever-to-be-a-good-software-engineer-32ek)
> * 原文作者：[Juraj Malenica](https://dev.to/mjurajs)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2023/unpopular-opinion-its-harder-than-ever-to-be-a-good-software-engineer.md](https://github.com/xitu/gold-miner/blob/master/article/2023/unpopular-opinion-its-harder-than-ever-to-be-a-good-software-engineer.md)
> * 译者：
> * 校对者：

[![Cover image for Unpopular Opinion: It’s harder than ever to be a good software engineer](https://res.cloudinary.com/practicaldev/image/fetch/s--rkh8tLqx--/c_imagga_scale,f_auto,fl_progressive,h_420,q_auto,w_1000/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/9re3vj1nlkfezgxeilxu.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--rkh8tLqx--/c_imagga_scale,f_auto,fl_progressive,h_420,q_auto,w_1000/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/9re3vj1nlkfezgxeilxu.png)

Working in a startup environment for almost a decade has given me privileged access to a fast-paced culture of innovation, exploration, and a fail-fast approach. I followed the standard progression ladder: intern, junior, mid, senior, and eventually moved to the engineering management track. Over time, many people I grew with later moved on to work at other companies, becoming highly-respected contributors there. It would be fair to say they are good engineers.

Looking back at the journey of my peers, mentees, and my own, it seems harder than ever to be a _good_ engineer.

## Defining a _good_ engineer

**What does it mean to be an engineer?** As software engineers, we are:

-   Responsible for translating complex problems into efficient and scalable solutions
-   Tasked with analyzing user requirements, designing software architecture, writing code, and testing and debugging software
-   Expected to stay on top of trends, seeking new business opportunities and ways to improve existing products

So no – engineering doesn’t equal programming. Sometimes, that is the smallest part. It definitely appears so as one acquires more experience, as shown in the figure below.

[![](https://res.cloudinary.com/practicaldev/image/fetch/s--BC97uBAb--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/xfcrp0dz22qnrhkas89u.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--BC97uBAb--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/xfcrp0dz22qnrhkas89u.png)

Source: [Engineering Leadership Skill Set Overlaps](https://newsletter.pragmaticengineer.com/p/engineering-leadership-skillset-overlaps)

**What does it mean to be a _good_ engineer?** Based on numerous interviews, and supporting my mentees’ progress, I noticed that people with different levels of expertise might give different answers.

Someone just starting out might think it’s the number of languages and frameworks a developer knows. A more experienced engineer might not even care about the language they’re using, instead emphasizing code quality - adhering to all coding principles and conducting QA, while moving swiftly.

Highly experienced engineers place an enormous focus on bringing value. Sometimes we’ll quickly write throw-away code that breaks all the rules to prove a hypothesis; sometimes we’ll spend days writing a couple of lines of mission-critical code. But most days, we are making architectural decisions, discussing mission-critical issues, improving processes, etc. Why? Because often, that brings the most value.

Although there are always exceptions to the rule, we can say that **a good engineer is one that efficiently focuses their effort to bring maximum value in achieving a goal.**

## Growing markets and competition

**The tech market is constantly evolving.** We have all seen massive successes over the years: from WhatsApp to Uber, Airbnb, and TikTok. While these may be exceptions, such examples often set the north star for people – something they should strive for. This way of thinking puts extra pressure on engineers. They feel stress from inside, thinking they're doing something wrong, and from outside, with people comparing their company to many competitors.

[![](https://res.cloudinary.com/practicaldev/image/fetch/s--XX8MRd4M--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/gpwm7yro8nqukgnfpbw6.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--XX8MRd4M--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/gpwm7yro8nqukgnfpbw6.png)

Source: [How Healthy is the Public Technology Market?](https://tomtunguz.com/tech-consolidation/)

To succeed in such an environment, companies needed to “move fast and break things,” as the famous Facebook motto says. Today this is more obvious than ever – almost every company is becoming an “AI company.” Everyone is integrating ChatGPT, often for no real reason, without a strategy on how it will bring value.

**By moving away from the core principle** – how can we bring more value to our customers – and moving towards beating the competition on the hype train, **we get engineers building functionalities that are doomed to fail.**

## World is a confusing place

What should an enthusiast such as myself do to become a better engineer? Apart from the obvious choice of perfecting coding skills by improving clean code and architecture philosophies, nowadays, there are lots of temptations lurking. Learning TypeScript and that one latest framework that changes everything, diving into the world of blockchain and crypto, experimenting with a myriad of AI products… Options are endless.

[![All javascript libraries](https://res.cloudinary.com/practicaldev/image/fetch/s--ge7Vyn7d--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/hz12rguhiupwiwmmsebt.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--ge7Vyn7d--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/hz12rguhiupwiwmmsebt.png)

To be honest, after so many years in the industry, I still felt threatened by the new wave of change brought by ChatGPT, GitHub Copilot, and other emerging tech. My brain started imagining scenarios where I’m out of touch on so many things. Am I focusing on the right things to bring value? Am I using my maximum potential?

After some time, it became clear we’re in a hype. That too will pass, leaving only AI companies that are creating long-term value. The number of AI companies in the last 5 years has doubled in the US, with many startups just adding a feature on top of then newly-released GPT-3. They would later die with the release of ChatGPT or GPT-4, which could do the same thing, but better. But that doesn’t stop the hype army of Twitter and other platforms from proclaiming the new world order.

Even with so many years working in tech, I got sucked into the hype. Rookie mistake!

Programming languages and constant releases of new frameworks also add to the confusion. Tailwind, TypeScript, Haskell and Rust are all great; they each have an angle which gives them an advantage. However, people often mistake learning them for something that will give them an edge. It won’t, or at least, it shouldn’t. They are just tools which are nice to know but can’t replace experience. That is why we never put language/framework requirements in our job descriptions. I would be a fool to miss a talented engineer because they don’t know TypeScript, prompt engineering, or microservices.

My advice is - **don’t get caught up in new trends and hypes to the point where you lose focus on bringing value.**

## Fast pace and high expectations

**When seeking new challenges, it can be difficult to strive for positive stress, while avoiding negative stress.** Positive stress is one where we perceive a stressful situation as an opportunity leading to a good outcome, while negative stress is one that can have detrimental physical and mental health effects, as seen in the image below. Continuously delivering results on a tight schedule is stressful, and building features for the wrong reasons sways towards the latter.

[![Positive stress vs. negative stress](https://res.cloudinary.com/practicaldev/image/fetch/s--1BnzUFGS--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/503c52srikb307qm3gw7.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--1BnzUFGS--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/503c52srikb307qm3gw7.png)

Both as a mentor and as a hard worker, I’ve seen stress lead to burnouts. Without exception, having someone go through burnout results in less output than reducing workload, taking a break, and optimizing for the long term. That's why we always try to make raising red flags as straightforward as possible, with periodic team updates, one-on-ones, and a nurturing culture.

Still, things will go wrong. When they do, we cut scope, involve people who can help, or communicate with our clients to postpone a launch.

**Pressure is higher than ever, coming both from within and without. Stay focused and surround yourself with a supportive team optimizing long-term.**

## How can we do better?

We all have our down moments – feeling like inadequate engineers, mentors, or colleagues. Things will never be perfect or easy, and they shouldn’t. Without making mistakes and hard times, we don’t learn. But there are some things I find can increase efficiency.

[![Levels of influence](https://res.cloudinary.com/practicaldev/image/fetch/s--lfFR4swd--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/omj6ri7izk3d2bz723w9.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--lfFR4swd--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_800/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/omj6ri7izk3d2bz723w9.png)

**Individually,** stay true to what is really important. Technologies will come and go, but the value you bring to the world is what counts. It’s hard to fake hard work and experience.

**As a company,** start with _why_ when making decisions. This is the best way to deliver functionalities that will bring value. Also, make sure the employees know that **_why_**. In my experience, they will make better decisions, give valuable feedback and be happier.

**Culturally,** establish processes that will support the employees, optimizing long-term. Together with your colleagues establish a culture of trust, support and caring. That way, you will all get the best of one another.

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。