> * 原文地址：[JavaScript Frontend Speed is the Next Big Thing](https://javascript.plainenglish.io/javascript-frontend-speed-is-the-next-big-thing-4caef920e441)
> * 原文作者：[Diop Makhtar](https://medium.com/@mkrdiop)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2022/javascript-frontend-speed-is-the-next-big-thing.md](https://github.com/xitu/gold-miner/blob/master/article/2022/javascript-frontend-speed-is-the-next-big-thing.md)
> * 译者：[Z招锦](https://github.com/zenblofe)
> * 校对者：[niayyy](https://github.com/nia3y)

![image from the courtesy of [Arrowhitech](https://www.arrowhitech.com/frontend-javascript-framework-what-is-it-benefits-and-top-10-best-ones-in-2020/)](https://cdn-images-1.medium.com/max/3200/0*ADxKDjcue-dFgLoK.png)

# 何时能有更快更强的前端开发框架

更快更轻量的 web 体验是大势所趋，开发团队正在为此重新设计前端开发解决方案。这不仅因为速度指标是搜索引擎考虑的重要指标，也是因为客户的时间价值。我们每个人都很清楚一句格言：时间就是金钱。对于 web 开发来说，构建和加载 web 应用程序花费更长的时间，相当于耗费更多 web 应用程序开发团队和客户的金钱。

大多数优化空间是在用户端，即浏览器端。在浏览器端操作 DOM 并更快的加载渲染，已经成为一个高优的事项，这使得前端开发团队在构建用户界面时，面临着更大的挑战。

现在，网络应用的缓慢有很大一部分原因来自网页的加载，因为不断增长的用于页面交互和简化开发的第三方 JavaScript 脚本，浏览器必须加载、编译和执行这些脚本。虽然通过压缩、打包、代码分割等，已经大大减少了 JavaScript 的加载时间和浏览器执行时间，但是还有改进余地，当然重新构想前端框架的设计和架构就是一种方法。

正是因为意识到提高加载速度的重要性，JavaScript 前端框架的开发者已经在重构项目代码，并努力使得开发框架更快更轻量，新的前端框架就是为了解决这些问题来进行构建的。例如 React 开发团队已经推出了一个名为 [Preact](https://preactjs.com/) 的更快更轻量的版本，专门为提高开发速度而打造的。对于 [Svelte](https://svelte.dev/) 这样的竞争对手，已经定位为与这个优化版的 React 开发框架进行比拼。更快的Web应用程序和体验的解决方案是一种双向路径，可以通过改进已有的前端框架（Preact）或采用一个新的框架（Svelte、[Inferno](https://www.infernojs.org/) 等）。

很多前端工程师都都在探索如何优化网络应用，减少加载时间。例如 [Nilanth](https://nilanth.medium.com/) 一直在使用新发布的 JavaScript 前端开发框架（例如 Preact）重构项目，并将其与使用的旧框架开发项目进行对比测试。通过阅读 [Nilanth](https://nilanth.medium.com/) 的[测试报告](https://javascript.plainenglish.io/dont-optimize-your-react-app-use-preact-instead-76cdc3e69b59)，会发现这种差异比那些关于 React、Vue 核心指标的测试文章中强调的差异更重要。

在评判前端开发框架的优劣时，需要考虑开发者生产效率和用户体验效果。有些让开发者更有生产力，但在用户体验方面的表现很差。有些难以实现较高的生产力，但也许在用户体验方面更好。

我的看法是，用户的体验是更有分量和优先权的。但我的产品管理和设计技能本能地大声说出了我为什么不说产品经理和设计师，而说软件工程师。因为我要说的这些话也是关于一种技术产品的设计和管理，这涉及到应用程序开发效率和性能测试，所有这些最终都是为了给用户提供更好的体验。

软件工程师的决策是建立在科学、知识、数据和技术的基础上，很多时候没有明确的框架性能和用户体验的情况下，就决定选择使用哪个前端开发框架。但是为什么不使用所有可用的框架来选择解决方案，并在用户的角度选择最合适的前端开发框架。

感谢您的阅读！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
