> * 原文地址：[Automation Testing: Everything You Should Know](https://blog.bitsrc.io/everything-you-need-to-know-about-automation-testing-c051e2e3444)
> * 原文作者：[Abhiraj Bhowmick](https://medium.com/@abhirajbhowmick)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2022/everything-you-need-to-know-about-automation-testing.md](https://github.com/xitu/gold-miner/blob/master/article/2022/everything-you-need-to-know-about-automation-testing.md)
> * 译者：[samyu2000](https://github.com/samyu2000)
> * 校对者：[Z招锦](https://github.com/zenblofe), [Mordomo](https://github.com/Mordomo)

# 自动化测试：你应当了解的一切

我们一直认为，自动化测试是一种从源头上提高应用程序质量的好办法。

然而，有一些真实情况，我们只有开始进行自动化测试时才会发现。

我们通常需要处理的问题有：决定何时进行自动化测试、哪些测试需要自动化、如何选择合适的技术以及如何编写符合最佳实践的自动化测试脚本。

![](https://cdn-images-1.medium.com/max/2000/1*5deSGTLdumw11ET2Mi5goA.png)

现在我们来详细讨论这些问题。

### 什么是自动化测试，它是如何工作的？

它是自动化工具运行测试套件，在应用程序中执行预定的操作，报告执行结果并比较，最后生成详细的测试报告的一套方法。

自动化测试需要花费一定的人力财力，也需要较长的开发周期，还会包含一些重复的操作。无论如何，在开始自动化测试前，我们必须首先确定自动化的最佳时机、自动化的范围和最合适的工具。如果这项工作没做好，就会给项目带来意想不到的额外成本。

自动化测试可以在非高峰时段（午夜）、在多台服务器上进行，花费的时间比手动测试少得多。这意味着开发人员和测试人员都能高效利用时间，团队也可以更快获得质量反馈。

## 自动化的标准

测试需要满足一定的条件才能自动化；否则，其结果就是付出的代价多于节省的资源。毕竟，自动化的根本目标是节省时间、人力和财力。

本文列举一些通用的测试自动化的标准。记住，这只是一些建议，标准也因使用场景而异。

### 可重复性

测试必须是可重复进行的。将只能运行一次的测试操作自动化是毫无意义的。创建一个可重复的测试操作，需要进行以下三步：

* 对测试进行配置，包括所需的数据和环境；
* 执行函数并得到结果；
* 清除相关数据和环境。

我们需要确保项目环境与初始阶段相同。

### 确定性

只要输入参数相同，每次执行函数的结果也都相同，这样的函数就是有确定性的。对于自动化测试来说也一样。

我们设想在测试程序中加入一个额外的函数。例如两个数相加，1 + 1 = 2,394.19 + 5.81 = 400.00。这个函数就是确定性的。

换句话说，软件会有很多个输入参数，随着时间的推移，要得到同样的结果是很有挑战性的。某些变量的值是随机的，很难预测函数执行结果。

### 非主观性

观点是不可自动化的。这就是可用性测试、beta 测试等其他主观性事物的亮点所在。用户体验固然重要，但它是不可自动化的。 

大多数开发者认为软件测试自动化需要投入大量的资金和资源。

## 不同级别的测试

决定自动化测试程序的数量的一种策略是测试自动化金字塔。这种策略建议人们以不同粒度的级别把测试分为三类。级别越高，需要写的测试程序越少。

## 自动化测试的类型

如果涉及到 QA 部门进行的集成测试，理解自动化测试的不同形式是非常重要的。它有助于你形成对自动化测试的综合性的认识，无论你是否将自动化测试跟你现在的 QA 程序结合。更进一步，需要理解各种类别的测试，从而选择一种能为公司带来最大收益的测试类型。

测试自动化的种类有很多。最常见的有以下几种：

### 代码分析

静态代码分析工具和动态代码分析工具是现有的众多代码分析工具中的两种。这些检查工具中，有的侧重于安全问题，有的侧重于风格和形式。

当开发者检入代码，这些测试程序也同时运行。对于这些自动化测试，除了配置规则和保持工具的更新之外，并没有太多的测试编写需要执行。

### 单元测试

单元测试是对各个组件进行独立测试，确保它们正常运行。因为单元测试通常已在开发阶段完成，所以它通常是第一类运行于应用程序的自动化测试程序。

### 集成测试

集成测试是把应用程序的多个元素作为一个整体进行测试。

涉及到自动化，集成测试就是一个独有的种类。集成测试，通常称为端到端测试，由于涉及到外部依赖，它较难进行。

当涉及到你无法获取的资源，通常较妥当的做法是构造虚拟的外部资源。

### 性能测试

性能测试是测试软件在一定负载下的运行速度、稳定性和响应性。

性能测试的基本目标是监测潜在的性能问题并消除它，令程序为用户提供最佳的使用体验。

由于性能测试有助于发现用户可能遇到的潜在问题（例如在高负载状态下运行缓慢），性能测试对于确保软件产品的成功销售非常重要。

### 回归测试

回归测试是一种维护测试。在修改代码后再次运行功能性和非功能性测试，旨在查看在某些代码或程序更改后软件的功能是否跟修改前一致。

如果前后的功能不相同，就称该软件倒退了。

回归测试的主要目的是确保代码修改后，原有的功能没有受到影响。

### 冒烟测试

冒烟测试，也称为“构建验证测试”和“可信度测试”，是一系列用来评估软件交付构建的稳定性和可行性的测试。

冒烟测试用于评估应用程序在缺少某种功能时，应当搁置还是转移到下一个测试阶段。当某种功能已经合并到软件构建版本时，需要进行冒烟测试。

本阶段出现的任何错误都会导致应用程序退回至开发团队，进行修改。

## 为何使用自动化测试

### 低成本

与一般的认识相反，自动化测试的成本比手工测试低。如果采用手工测试的方式，你无法进行重复的测试。实际上，手工测试的成本是随着时间推移而增加的。

另一方面，只要你构建了测试脚本，自动化测试的长期成本是较低的，任何时候你都可以反复使用，没有额外成本。

记住，自动化测试的投入产出比取决于自动化的程度，这很重要。预期的投资回报越高，你需要创建和使用的自动化测试用例就越多。

### 节省时间

你可以借助自动化测试节省工作时间。自动化测试执行快，也可以重复执行。换句话说，等待下一次测试的时间不再是若干周——只需要几个小时就够了。

自动化测试以其执行速度快、可重复的优势提高了开发效率。从手工测试转向自动化测试可以缩短开发时间，提高产出。

### 精确度更高

如果你使用自动化测试，很可能得到无错误的版本。由于自动化测试需要的人为干预少，所以它比手工测试更精确。

问题是，人工测试在任何阶段都会出错。

另一方面，机器不会配合手工测试。由于创建好的测试用例比人工测试更精确，你可以通过排除人为错误降低出现错误的可能性。

### 即时反馈

自动化测试的另一个优势是，它提供即时的反馈。

由于测试程序执行得快，开发者可以立刻收到测试报告，如果存在问题，就可以快速做出响应。别想着破译三周前写的代码了。

当你得应用程序已经面市，即时反馈也是很有用得。如果需要立刻修复一些错误，手工测试会令整个过程进展缓慢。

此外，测试自动化也有助于你快速修改应用程序。

所以，自动化测试提高了团队的响应能力，改善了用户体验和客户满意度。

### DevOps的实现

所有对源代码的提交都需要作为 CI/CD 流水线的一部分进行测试，只有自动化测试才可以快速高效实现。

所以，当你已经部署了自动化测试，过渡到持续测试和交付的阶段是很方便的。

当代码的复杂度和测试用例数量增加，就越来越难以管理。

## 何时使用自动化测试

如果你反复运行相同的测试程序，而且不对它进行改动，自动化可能令你节省很多时间。那是因为，经常进行手工测试是浪费时间的，而且可能由于疏忽会导致额外的错误。

有了自动化，人为错误就不再会发生了。所以，在某些情况下，使用自动化测试能大大提升项目质量。

如果能交付高质量的产品，同时能够节省成本，当然应该这么做。这就是自动化的优势。大多数自动化技术都不便宜，所以项目应当足够大，才有可能实现盈利。

## 关于自动化测试的认识误区

的确，测试自动化能令你节省时间。如果实施手工测试，大部分时间会花在探索性问题和功能测试（排查错误）上。

当完成这些过程，测试人员仍然需要反复进行相同的操作。如果使用自动化测试，所花费的时间就会少很多。测试人员可以重点关注代码，并根据需要进行优化，而不需要写大量测试程序。

然而，测试完成后，自动化测试工具可以重用测试程序，而不需要重复进行某些操作。

自动化测试能令你关注更重要的事项，例如客户需求、功能和性能优化。

更进一步，源代码一旦修改，测试程序都会运行一遍。手工运行这些测试程序费时费力，而自动化测试就能反复运行，无额外成本。

关于自动化测试的另外一个认识误区是：它会减少人工干预的需要。

实话实说，自动化测试比人工测试更精准、更快，而且不会犯人工可能出现的错误，所以有这种认识误区很正常。

但这不能代替软件开发中面对面的沟通。相反，由于它开辟了额外的沟通渠道，沟通就变得更重要了。

## 哪些模块需要自动化

测试工具不必实现端到端的自动化测试，就可以辅助执行某些任务，比如产品安装、测试数据创建、用户界面、问题检测（用于测试 Oracle 的解析或轮询代理）、错误跟踪等。

我们不应该尝试自动化负面或故障转移测试，因为它们需要测试人员进行分析性的思考，而负面测试无法得到某些通过或失败的结果。

## 谁应该参与测试自动化工具的开发？

在短期的敏捷迭代中，测试经常需要奉行“向左移”策略。测试工作在敏捷开发过程中向左转移，就可以在应用程序生命周期的早期阶端开始。

所以，技术较好的开发人员也会对测试负责，会与测试人员频繁沟通，旨在帮助他们开发自动化测试框架。

当评估一套测试方案时，需要满足所有会参与到测试工作中的团队成员的需求。手工测试人员、自动化工程师、开发者都包括在内。

## 如何使测试程序自动化

如果你想了解如何令测试程序自动化，需要进行以下5个简单步骤：

### 1. 选择用于测试的软件或工具

在你决定哪些测试程序需要自动化后，你可以找到很多测试工具可供使用。选择之前，你需要考虑工具如何在你现有的软件平台上运行，也就是哪种工具跟软件平台更适配。

### 2. 决定哪些测试程序可以自动化

首先，选择你需要自动化的测试程序。许多软件工程师同时使用手工测试和自动化测试。某些功能可能需要手工测试。有了UI-licious，你可以从0编码知识开始。

### 3. 计划，设计并编写脚本

选定了自动化测试工具后，对框架的设计及其特点进行规划。接着你可以规划自动化测试的相关事项（in-scope 和 out-of-scope）。然后，你可以开始编写脚本并执行程序。

### 4. 执行测试程序

在这个阶段，你运行了自动化脚本。在脚本程序可运行前，有的脚本是需要带输入参数的。当它们运行后，会生成测试报告，你可以方便地分析测试报告，并与你的团队共享。

### 5. 维护你的测试脚本

自动化测试脚本的维护阶段，需要留意软件中加入的新特性是否正常运行。当新的测试脚本添加进来，为了提升每个周期的自动化脚本运行效率，必须对其进行复查和维护。

## 结论

测试自动化令测试人员可以进行更多的探索性测试，从而发现更多自动化测试发现不了的缺陷。因此，无论什么项目，自动化测试都是有助于节省时间和成本的。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
